/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.advice;

import cn.gtmap.ai.core.annotation.desensitization.FieldDesensitize;
import cn.gtmap.ai.core.annotation.desensitization.TableDesensitize;
import cn.gtmap.ai.core.base.RestReturnResultDto;
import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.base.ReturnResultItem;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.BizException;
import cn.gtmap.ai.core.exception.IError;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class CustomResponseBodyAdviceAdapter
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(CustomResponseBodyAdviceAdapter.class);
    private static final Logger logger = LoggerFactory.getLogger(CustomResponseBodyAdviceAdapter.class);
    @Autowired
    NativeWebRequest webRequest;

    public boolean supports(MethodParameter returnType, Class converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (Objects.isNull(body)) {
            throw new BizException((IError)ErrorEnum.PARAM_NULL);
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.webRequest.getNativeRequest(HttpServletRequest.class);
        Object allmessage = httpServletRequest.getAttribute("allmessage");
        try {
            Object data = null;
            if (body instanceof ReturnResult && (Objects.isNull(allmessage) || !((Boolean)allmessage).booleanValue())) {
                ReturnResult result = (ReturnResult)body;
                if (!result.isSuccess() || Objects.isNull(result.getData())) {
                    return result;
                }
                data = result.getData();
            } else if (body instanceof RestReturnResultDto && (Objects.isNull(allmessage) || !((Boolean)allmessage).booleanValue())) {
                RestReturnResultDto result = (RestReturnResultDto)body;
                if (!result.isSuccess() || Objects.isNull(result.getData())) {
                    return result;
                }
                data = result.getData();
            }
            if (!Objects.isNull(data)) {
                this.desensitizeResult(data);
            }
        }
        catch (Exception e) {
            logger.error("beforeBodyWrite\u65b9\u6cd5\u5f02\u5e38\u4fe1\u606f\uff1a", (Object)e.getMessage());
        }
        return body;
    }

    public void desensitizeResult(Object data) {
        if (data instanceof Collection) {
            this.desensitizeCollection((Collection)data);
        } else if (data instanceof ReturnResultItem) {
            this.desensitizeReturnResultItem((ReturnResultItem)data);
        } else if (data instanceof Map) {
            this.desensitizeMap((Map)data);
        }
    }

    public void desensitizeCollection(Collection collection) {
        for (Object o : collection) {
            if (Objects.isNull(o)) continue;
            if (o instanceof Collection) {
                this.desensitizeCollection((Collection)o);
                continue;
            }
            if (o instanceof ReturnResultItem) {
                this.desensitizeReturnResultItem((ReturnResultItem)o);
                continue;
            }
            if (!(o instanceof Map)) continue;
            this.desensitizeMap((Map)o);
        }
    }

    public void desensitizeReturnResultItem(ReturnResultItem returnResultItem) {
        TableDesensitize tTableDesensitizeAnnotation = returnResultItem.getClass().getAnnotation(TableDesensitize.class);
        if (Objects.isNull(tTableDesensitizeAnnotation)) {
            return;
        }
        Field[] fields = returnResultItem.getClass().getDeclaredFields();
        if (Objects.isNull(fields)) {
            return;
        }
        for (Field field : fields) {
            FieldDesensitize fieldDesensitizeAnnotation = field.getAnnotation(FieldDesensitize.class);
            try {
                Field targetField;
                field.setAccessible(true);
                Object obj = field.get(returnResultItem);
                if (Objects.isNull(obj)) continue;
                if (obj instanceof Collection) {
                    this.desensitizeCollection((Collection)obj);
                    continue;
                }
                if (obj instanceof Map) {
                    this.desensitizeMap((Map)obj);
                    continue;
                }
                if (obj instanceof ReturnResultItem) {
                    this.desensitizeReturnResultItem((ReturnResultItem)obj);
                    continue;
                }
                if (Objects.isNull(fieldDesensitizeAnnotation) || StringUtils.isEmpty((CharSequence)fieldDesensitizeAnnotation.targetFieldName()) || Objects.isNull(targetField = returnResultItem.getClass().getDeclaredField(fieldDesensitizeAnnotation.targetFieldName()))) continue;
                targetField.setAccessible(true);
                targetField.set(returnResultItem, null);
            }
            catch (Exception e) {
                log.error("\u8131\u654f{}\u5bf9\u8c61\u7684{}\u5c5e\u6027\u503c\u9519\u8bef", returnResultItem.getClass(), (Object)fieldDesensitizeAnnotation.targetFieldName());
            }
        }
    }

    public void desensitizeMap(Map<String, Object> map) {
        for (Map.Entry<String, Object> stringObjectEntry : map.entrySet()) {
            Object o = stringObjectEntry.getValue();
            if (Objects.isNull(o)) continue;
            if (o instanceof Collection) {
                this.desensitizeCollection((Collection)o);
                continue;
            }
            if (o instanceof ReturnResultItem) {
                this.desensitizeReturnResultItem((ReturnResultItem)o);
                continue;
            }
            if (!(o instanceof Map)) continue;
            this.desensitizeMap((Map)o);
        }
    }
}

