/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.leas.utils;

import cn.gtmap.leas.core.ex.AppException;
import cn.gtmap.leas.core.ex.Source;
import cn.gtmap.leas.core.ex.SourceExtractor;
import cn.gtmap.leas.core.i18n.NLS;
import com.google.common.collect.Sets;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.NestedRuntimeException;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MissingServletRequestParameterException;

public final class ExUtils {
    public static Throwable getRootCause(Throwable cause) {
        Throwable rootCause = null;
        while (cause != null && cause != rootCause) {
            rootCause = cause;
            cause = cause.getCause();
        }
        return rootCause;
    }

    public static AppException wrap(Throwable ex) {
        if (ex instanceof InvocationTargetException) {
            ex = ((InvocationTargetException)ex).getTargetException();
        }
        if (ex instanceof AppException) {
            return (AppException)ex;
        }
        return new AppException(ex);
    }

    public static void throwEx(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw ExUtils.wrap(ex);
    }

    public static void throwRoot(Exception e) {
        ExUtils.throwEx(ExUtils.getRootCause(e));
    }

    public static Exception raw(Exception ex) {
        return ex instanceof InvocationTargetException ? (Exception)((InvocationTargetException)ex).getTargetException() : ex;
    }

    public static int parseCode(Throwable cause) {
        if (cause instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        if (cause instanceof AppException) {
            return ((AppException)cause).getCode();
        }
        if (cause instanceof NullPointerException) {
            return 2;
        }
        if (cause instanceof SocketException) {
            return 9;
        }
        if (cause instanceof SQLException) {
            return 10;
        }
        if (cause instanceof IOException) {
            return 8;
        }
        if (cause instanceof TemplateException) {
            return 81;
        }
        if (cause instanceof ClassNotFoundException || cause instanceof IllegalAccessException) {
            return 7;
        }
        if (cause instanceof UnsupportedOperationException) {
            return 6;
        }
        if (cause instanceof IllegalStateException) {
            return 51;
        }
        if (cause instanceof IllegalArgumentException) {
            return cause instanceof IllegalFormatException ? 53 : 52;
        }
        if (cause instanceof VirtualMachineError) {
            if (cause instanceof OutOfMemoryError) {
                return 3;
            }
            if (cause instanceof StackOverflowError) {
                return 4;
            }
        }
        return 1;
    }

    public static String buildMessage(int code, Object[] args, String customMessage, Throwable cause) {
        String message = NLS.get("error." + code, args);
        if (message == null) {
            message = "errorcode:" + code;
        }
        if (StringUtils.isNotEmpty((CharSequence)customMessage)) {
            message = message + ", " + customMessage;
        }
        if (cause != null) {
            message = ExUtils.buildNestedMessage(message, cause);
        }
        return message;
    }

    public static String buildNestedMessage(String message, Throwable ex) {
        StringBuilder sb = new StringBuilder(message);
        HashSet visitedExceptions = Sets.newHashSet();
        Throwable tmpEx = ex;
        do {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(tmpEx);
            visitedExceptions.add(tmpEx);
        } while ((tmpEx = tmpEx.getCause()) != null && !visitedExceptions.contains(tmpEx) && !(tmpEx instanceof AppException) && !(tmpEx instanceof NestedRuntimeException));
        return sb.toString();
    }

    public static String buildNestedMessage(Throwable ex) {
        return ExUtils.buildNestedMessage("", ex);
    }

    public static String buildStackTrace(Throwable cause) {
        StringWriter sw = new StringWriter();
        cause.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Map<String, Object> toMap(Exception ex) {
        int code;
        String msg = null;
        if (ex instanceof AppException) {
            code = ((AppException)ex).getCode();
            msg = ex.getMessage();
        } else {
            code = ex instanceof MissingServletRequestParameterException ? 54 : (ex instanceof TypeMismatchException || ex instanceof BindException ? 52 : ExUtils.parseCode(ex));
        }
        if (msg == null) {
            msg = ExUtils.buildNestedMessage(ex);
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(3);
        map.put("ret", code);
        map.put("msg", msg);
        return map;
    }

    public static Source extractSource(List<SourceExtractor> sourceExtractors, Throwable ex) {
        for (SourceExtractor se : sourceExtractors) {
            Source source;
            if (!se.isSupport(ex) || (source = se.extract(ex)) == null) continue;
            return source;
        }
        return null;
    }

    private ExUtils() {
    }
}

