/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.leas.core.support.xml;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

public class XmlUtils<T> {
    private JAXBContext jaxbContext;

    public XmlUtils(Class<?> ... types) {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])types);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public String entityToXml(Object object) {
        return this.entityToXml(object, null);
    }

    public String entityToXml(Object object, String encoding) {
        String xmlStr = "";
        try {
            if (object != null) {
                Annotation[] aos = object.getClass().getAnnotations();
                Boolean bol = false;
                for (Annotation ao : aos) {
                    if (!ao.annotationType().equals(XmlRootElement.class)) continue;
                    bol = true;
                    break;
                }
                if (bol.booleanValue()) {
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
                    Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                    jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                    if (StringUtils.isNotBlank((CharSequence)encoding)) {
                        jaxbMarshaller.setProperty("jaxb.encoding", (Object)encoding);
                    }
                    StringWriter writer = new StringWriter();
                    jaxbMarshaller.marshal(object, (Writer)writer);
                    xmlStr = writer.toString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlStr;
    }

    public <T> T fromXml(String xml, boolean caseSensitive) {
        try {
            String fromXml = xml;
            if (!caseSensitive) {
                fromXml = xml.toLowerCase();
            }
            StringReader reader = new StringReader(fromXml);
            return (T)this.createUnmarshaller().unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public Unmarshaller createUnmarshaller() {
        try {
            return this.jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromXml(String xml) {
        try {
            StringReader reader = new StringReader(xml);
            return (T)this.createUnmarshaller().unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

