/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.leas.core.support.spring;

import cn.gtmap.leas.core.support.mybatis.page.model.PageDefault;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class DataPageableHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.getParameterType().equals(Pageable.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Integer page;
        Integer rows;
        PageDefault def = (PageDefault)parameter.getParameterAnnotation(PageDefault.class);
        if (def != null) {
            rows = this.getParam(webRequest, "rows", def.prefix(), def.value());
            page = this.getParam(webRequest, "page", def.prefix(), def.offset());
        } else {
            rows = this.getParam(webRequest, "rows", null, null);
            page = this.getParam(webRequest, "page", null, null);
        }
        if (rows == null && page == null) {
            return new PageRequest(0, 20);
        }
        if (rows == null) {
            rows = 20;
        }
        page = page == null ? Integer.valueOf(0) : Integer.valueOf(page - 1);
        return new PageRequest(page.intValue(), rows.intValue());
    }

    private Integer getParam(NativeWebRequest webRequest, String name, String prefix, Integer def) {
        String s = webRequest.getParameter(StringUtils.isEmpty((CharSequence)prefix) ? name : prefix + "_" + name);
        return StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{s}) ? Integer.valueOf(s) : def;
    }
}

