/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.leas.core.support.mybatis.page.model;

import cn.gtmap.leas.core.support.mybatis.page.model.Page;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.data.domain.Pageable;

public class PageImpl<T>
implements Page<T>,
Serializable {
    private final List<T> rows = new ArrayList<T>();
    private final int total;
    private final int records;
    private final int page;
    private final int pageSize;

    public PageImpl(Collection<? extends T> content, int page, int total, int limit) {
        this.rows.addAll(content);
        this.records = total;
        this.page = page;
        this.pageSize = limit;
        this.total = CollectionUtils.isNotEmpty(content) ? (total % limit == 0 ? total / limit : total / limit + 1) : 1;
    }

    public PageImpl(Collection<? extends T> content, int total, Pageable pageable) {
        this.rows.addAll(content);
        this.records = total;
        this.page = pageable.getPageNumber() + 1;
        this.pageSize = pageable.getPageSize();
        if (pageable.getPageSize() < 0) {
            this.total = 0;
        } else {
            int count = total / pageable.getPageSize();
            this.total = total % pageable.getPageSize() != 0 ? count + 1 : count;
        }
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public int getRecords() {
        return this.records;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    @JSONField(serialize=false)
    public int getItemSize() {
        return this.getRows().size();
    }

    @Override
    public List<T> getRows() {
        return this.rows;
    }

    @Override
    public T getRow(int index) {
        return this.rows.get(index);
    }
}

