/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.leas.core.support.freemarker;

import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HttpScopesHashModel
extends SimpleHash {
    private static final long serialVersionUID = -303440337217898597L;
    private final ServletContext context;
    private final HttpServletRequest request;

    public HttpScopesHashModel(ObjectWrapper wrapper, ServletContext context, HttpServletRequest request) {
        this.setObjectWrapper(wrapper);
        this.context = context;
        this.request = request;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        TemplateModel model = super.get(key);
        if (model != null) {
            return model;
        }
        Object obj = this.request.getAttribute(key);
        if (obj != null) {
            return this.wrap(obj);
        }
        HttpSession session = this.request.getSession(false);
        if (session != null && (obj = session.getAttribute(key)) != null) {
            return this.wrap(obj);
        }
        obj = this.context.getAttribute(key);
        if (obj != null) {
            return this.wrap(obj);
        }
        String[] param = this.request.getParameterValues(key);
        if (param != null) {
            switch (param.length) {
                case 0: {
                    break;
                }
                case 1: {
                    return new SimpleScalar(param[0]);
                }
                default: {
                    return new SimpleSequence(Arrays.asList(param), this.getObjectWrapper());
                }
            }
        }
        return this.wrap(null);
    }
}

