/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.leas.core.support.fastjson;

import cn.gtmap.leas.core.support.fastjson.Helper;
import cn.gtmap.leas.utils.Charsets;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class FastjsonHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    public static final Charset DEFAULT_CHARSET = Charsets.CHARSET_UTF8;
    private String jsonpParameterName = "callback";

    public void setJsonpParameterName(String jsonpParameterName) {
        this.jsonpParameterName = jsonpParameterName;
    }

    public FastjsonHttpMessageConverter() {
        super(new MediaType("application", "json", DEFAULT_CHARSET));
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return JSON.parseObject((byte[])FileCopyUtils.copyToByteArray((InputStream)inputMessage.getBody()), clazz, (Feature[])new Feature[0]);
    }

    protected void writeInternal(Object o, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Helper.render(o, ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getParameter(this.jsonpParameterName), new OutputStreamWriter(outputMessage.getBody(), DEFAULT_CHARSET));
    }
}

