/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landsale.web.freemarker;

import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.PageRequest;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.landsale.model.LandUseDict;
import cn.gtmap.landsale.model.Partner;
import cn.gtmap.landsale.model.TransCo;
import cn.gtmap.landsale.model.TransCrgg;
import cn.gtmap.landsale.model.TransResource;
import cn.gtmap.landsale.model.TransResourceApply;
import cn.gtmap.landsale.security.SecUtil;
import cn.gtmap.landsale.service.LandUseDictSerivce;
import cn.gtmap.landsale.service.PartnerService;
import cn.gtmap.landsale.service.TransCoService;
import cn.gtmap.landsale.service.TransCrggService;
import cn.gtmap.landsale.service.TransResourceApplyService;
import cn.gtmap.landsale.service.TransResourceService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    TransResourceService transResourceService;
    TransCrggService transCrggService;
    TransResourceApplyService transResourceApplyService;
    PartnerService partnerService;
    LandUseDictSerivce landUseDictSerivce;
    TransCoService transCoService;

    public void setTransCoService(TransCoService transCoService) {
        this.transCoService = transCoService;
    }

    public void setLandUseDictSerivce(LandUseDictSerivce landUseDictSerivce) {
        this.landUseDictSerivce = landUseDictSerivce;
    }

    public void setPartnerService(PartnerService partnerService) {
        this.partnerService = partnerService;
    }

    public void setTransResourceApplyService(TransResourceApplyService transResourceApplyService) {
        this.transResourceApplyService = transResourceApplyService;
    }

    public void setTransResourceService(TransResourceService transResourceService) {
        this.transResourceService = transResourceService;
    }

    public void setTransCrggService(TransCrggService transCrggService) {
        this.transCrggService = transCrggService;
    }

    public TransResource getResource(String resourceId) {
        return this.transResourceService.getTransResource(resourceId);
    }

    public TransResourceApply getResourceApply(String applyId) {
        return this.transResourceApplyService.getTransResourceApply(applyId);
    }

    public TransCrgg getCrgg(String ggId) {
        return StringUtils.isNotBlank((CharSequence)ggId) ? this.transCrggService.getTransCrgg(ggId) : null;
    }

    public TransResourceApply limitTimeOffer(String resourceId) {
        TransResourceApply transResourceApply;
        TransResource transResource = this.transResourceService.getTransResource(resourceId);
        if (Calendar.getInstance().getTime().before(transResource.getGpEndTime()) && transResource.getGpEndTime().getTime() - Calendar.getInstance().getTime().getTime() < 3600000L && (transResourceApply = this.transResourceApplyService.getTransResourceApplyByUserId(SecUtil.getLoginUserId(), resourceId)).getApplyStep() == 3) {
            return transResourceApply;
        }
        return null;
    }

    public int getApplyCountByStauts() {
        String userId = SecUtil.getLoginUserId();
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            HashSet regions = Sets.newHashSet();
            Page<TransResource> transResourcePage = this.transResourceService.findTransResourcesByUser(userId, 2, regions, (Pageable)new PageRequest(0, 50));
            return transResourcePage.getItems().size();
        }
        return 0;
    }

    public List<Partner> getPartnerListByApplyId(String applyId) {
        List<Object> partners = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)applyId)) {
            partners = this.partnerService.getPartnerList(applyId);
        }
        return partners;
    }

    public int getTransResourceApply(String resourceId, int applyStep) {
        if (StringUtils.isNotBlank((CharSequence)resourceId) && null != this.transResourceApplyService.getTransResourceApplyStep(resourceId, applyStep)) {
            return this.transResourceApplyService.getTransResourceApplyStep(resourceId, applyStep).size();
        }
        return 0;
    }

    public List<LandUseDict> getLandUseDictList() {
        return this.landUseDictSerivce.getLandUseDictList();
    }

    public LandUseDict getLandUseDict(String code) {
        LandUseDict dict = null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            dict = this.landUseDictSerivce.getLandUseDict(code);
        }
        LandUseDict landUseDict = dict = dict == null ? new LandUseDict() : dict;
        if (dict.getName() == null) {
            dict.setName("");
        }
        return dict;
    }

    public TransCo getTransCo(String coId) {
        return this.transCoService.getTransUserByCoId(coId);
    }
}

