/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landsale.security;

import cn.gtmap.egovplat.core.util.RequestUtils;
import cn.gtmap.landsale.model.TransUser;
import cn.gtmap.landsale.security.SecurityContext;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecUtil {
    static final String USER_ID_KEY = "_USER_ID";
    static final String USER_NAME_KEY = "_USER_VIEW_NAME";
    static final String USER_REGIONS = "_USER_REGION_CODE";
    static final String USER_RESOURCES = "_USER_RESOURCE_PRIVILEGE";
    static final PathMatcher pathMatcher = RequestUtils.PATH_MATCHER;

    public static boolean isLogin() {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{SecUtil.getLoginUserId()});
    }

    public static String getLoginUserId() {
        return SecurityContext.getContext().getAttr().getAttr(USER_ID_KEY);
    }

    public static String getLoginUserViewName() {
        return SecurityContext.getContext().getAttr().getAttr(USER_NAME_KEY);
    }

    public static void setLoginUserIdToLocal(String userId, String viewName) {
        SecurityContext.getContext().getAttr().setAttr(USER_ID_KEY, (Object)userId);
        SecurityContext.getContext().getAttr().setAttr(USER_NAME_KEY, (Object)viewName);
    }

    public static void setLoginUserIdToSession(HttpServletRequest request, TransUser transUser) {
        WebUtils.setSessionAttribute((HttpServletRequest)request, (String)USER_ID_KEY, (Object)transUser);
    }

    public static boolean login4Session(HttpServletRequest request) {
        Object userIdObj = WebUtils.getSessionAttribute((HttpServletRequest)request, (String)USER_ID_KEY);
        if (userIdObj != null) {
            TransUser transUser = (TransUser)userIdObj;
            SecUtil.setLoginUserToLocal(transUser);
            return true;
        }
        SecUtil.clearContextAttr(false);
        return false;
    }

    public static void setLoginUserToLocal(TransUser transUser) {
        SecurityContext.getContext().getAttr().setAttr(USER_ID_KEY, (Object)transUser.getUserId());
        SecurityContext.getContext().getAttr().setAttr(USER_NAME_KEY, (Object)transUser.getViewName());
        String privileges = transUser.getPrivilege();
        if (StringUtils.isNotBlank((CharSequence)privileges)) {
            JSONObject privilegeMap = JSON.parseObject((String)privileges);
            if (privilegeMap.containsKey("regions")) {
                SecurityContext.getContext().getAttr().setAttr(USER_REGIONS, (Object)Sets.newHashSet((Iterable)((List)privilegeMap.get("regions"))));
            }
            if (privilegeMap.containsKey("resources")) {
                SecurityContext.getContext().getAttr().setAttr(USER_RESOURCES, privilegeMap.get("resources"));
            }
        }
    }

    public static void logout4Session(HttpServletRequest request) {
        WebUtils.setSessionAttribute((HttpServletRequest)request, (String)USER_ID_KEY, null);
        SecUtil.clearContextAttr(true);
    }

    private static void clearContextAttr(boolean isClearAll) {
        SecurityContext.getContext().getAttr().removeAttr(USER_ID_KEY);
        SecurityContext.getContext().getAttr().removeAttr(USER_NAME_KEY);
        SecurityContext.getContext().getAttr().removeAttr(USER_REGIONS);
        SecurityContext.getContext().getAttr().removeAttr(USER_RESOURCES);
        if (isClearAll) {
            SecurityContext.clearContext();
        }
    }

    public static boolean isAdmin() {
        return "0".equals(SecUtil.getLoginUserId());
    }

    public static boolean isPermitted(String path, Collection<String> operations) {
        if (CollectionUtils.isEmpty(operations)) {
            return false;
        }
        Set<String> userOps = SecUtil.getPermittedOperations(path);
        for (String op : operations) {
            if (userOps.contains(op)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPermitted(String path, String resourceName, Collection<String> operations) {
        if (CollectionUtils.isEmpty(operations)) {
            return false;
        }
        Set<String> userOps = SecUtil.getPermittedOperations(path, resourceName);
        for (String op : operations) {
            if (userOps.contains(op)) continue;
            return false;
        }
        return true;
    }

    public static Set<String> getPermittedOperations(String path, String resourceName) {
        HashSet operations = Sets.newHashSet();
        String resources = (String)SecurityContext.getContext().getAttr().getAttr(USER_RESOURCES, String.class, null);
        if (StringUtils.isNotBlank((CharSequence)resources)) {
            List resourcePrivileges = (List)JSON.parseObject((String)resources, List.class);
            for (Map privilege : resourcePrivileges) {
                if (StringUtils.isBlank((CharSequence)resourceName)) {
                    if (!pathMatcher.match(String.valueOf(privilege.get("url")), path)) continue;
                    operations.add(String.valueOf(privilege.get("operation")));
                    continue;
                }
                if (!pathMatcher.match(String.valueOf(privilege.get("url")), path) || !resourceName.equals(privilege.get("name"))) continue;
                operations.add(String.valueOf(privilege.get("operation")));
            }
        }
        return operations;
    }

    public static Set<String> getPermittedOperations(String path) {
        return SecUtil.getPermittedOperations(path, null);
    }

    public static Set<String> getPermittedRegions() {
        String regions = (String)SecurityContext.getContext().getAttr().getAttr(USER_REGIONS, String.class, null);
        if (StringUtils.isBlank((CharSequence)regions)) {
            return Sets.newHashSet((Object[])new String[]{"-999"});
        }
        Set result = (Set)JSON.parseObject((String)regions, Set.class);
        if (result == null || result.isEmpty()) {
            return Sets.newHashSet((Object[])new String[]{"-999"});
        }
        return result;
    }
}

