/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landsale.security;

import cn.gtmap.egovplat.core.util.RequestUtils;
import cn.gtmap.landsale.security.SecUtil;
import cn.gtmap.landsale.security.SecurityContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;

public class SecContextInterceptor
implements HandlerInterceptor {
    private String[] excludes;
    private String[] needLogins;
    private String redirectUrl;
    protected UrlPathHelper urlPathHelper = RequestUtils.URL_PATH_HELPER;
    protected PathMatcher pathMatcher = RequestUtils.PATH_MATCHER;

    public void setNeedLogins(String[] needLogins) {
        this.needLogins = needLogins;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        if (!RequestUtils.matchAny((HttpServletRequest)request, (UrlPathHelper)this.urlPathHelper, (PathMatcher)this.pathMatcher, (String[])this.excludes)) {
            boolean login = SecUtil.login4Session(request);
            if (RequestUtils.matchAny((HttpServletRequest)request, (UrlPathHelper)this.urlPathHelper, (PathMatcher)this.pathMatcher, (String[])this.needLogins)) {
                if (this.redirectUrl == null || login) {
                    return true;
                }
                response.sendRedirect(this.redirectUrl + (this.redirectUrl.contains("?") ? "&" : "?") + "url=" + ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request).build().encode());
                return false;
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
        if (RequestUtils.matchAny((HttpServletRequest)request, (UrlPathHelper)this.urlPathHelper, (PathMatcher)this.pathMatcher, (String[])this.excludes)) {
            SecurityContext.clearContext();
        }
    }
}

