/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landsale.security;

import cn.gtmap.egovplat.core.util.RequestUtils;
import cn.gtmap.egovplat.security.ex.NoPermissonException;
import cn.gtmap.landsale.Constants;
import cn.gtmap.landsale.security.SecUtil;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.UrlPathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationInterceptor
implements HandlerInterceptor {
    private String rootPath;
    private Map<String, Collection<String>> privileges = Maps.newLinkedHashMap();
    protected UrlPathHelper urlPathHelper = RequestUtils.URL_PATH_HELPER;
    protected PathMatcher pathMatcher = RequestUtils.PATH_MATCHER;

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setPrivileges(Map<String, String> privileges) {
        for (Map.Entry<String, String> entry : privileges.entrySet()) {
            String value = entry.getValue();
            if (StringUtils.isEmpty((CharSequence)value)) {
                value = Constants.Operation.VIEW.toString();
            }
            this.privileges.put(entry.getKey(), Arrays.asList(StringUtils.split((String)value, (char)',')));
        }
    }

    public boolean internalPreHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String lookupPath = this.urlPathHelper.getLookupPathForRequest(request);
        for (Map.Entry<String, Collection<String>> entry : this.privileges.entrySet()) {
            String path = entry.getKey();
            if (!this.pathMatcher.match(path, lookupPath)) continue;
            if (SecUtil.isAdmin() || SecUtil.isPermitted(lookupPath, null, entry.getValue())) break;
            throw new NoPermissonException(lookupPath);
        }
        return true;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return this.internalPreHandle(request, response, handler);
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }
}

