/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.zjjg;

import cn.gtmap.hlw.core.domain.zjjg.ZjjgxxThirdEventService;
import cn.gtmap.hlw.core.domain.zjjg.model.ZjjgxxThirdParamModel;
import cn.gtmap.hlw.core.domain.zjjg.model.ZjjgxxThirdResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZjjgxxThirdDomainService {
    private static final Logger log = LoggerFactory.getLogger(ZjjgxxThirdDomainService.class);
    @Resource
    GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, ZjjgxxThirdEventService> eventServiceMap;

    public ZjjgxxThirdResultModel event(ZjjgxxThirdParamModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        ZjjgxxThirdResultModel resultModel = new ZjjgxxThirdResultModel();
        log.info("\u7b2c\u4e09\u65b9\u8d44\u91d1\u76d1\u7ba1\u4fe1\u606f\u67e5\u8be2lysjList:{}", (Object)JSON.toJSONString((Object)lysjList));
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            ZjjgxxThirdEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }
}

