/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.yjjf.event;

import cn.gtmap.hlw.core.domain.yjjf.YjJfEventService;
import cn.gtmap.hlw.core.domain.yjjf.model.cxjfxx.YjCxJfxxParamsModel;
import cn.gtmap.hlw.core.domain.yjjf.model.scdd.YjJfResultModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class YjJfDomainService {
    private static final Logger log = LoggerFactory.getLogger(YjJfDomainService.class);
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, YjJfEventService> eventServiceMap;

    public YjJfResultModel event(YjCxJfxxParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), null);
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        YjJfResultModel resultModel = new YjJfResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            try {
                YjJfEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                eventService.doWork(paramsModel, resultModel);
            }
            catch (Exception e) {
                log.error("\u6708\u7ed3\u7f34\u8d39\u4e8b\u4ef6\u9519\u8bef\uff1a", (Throwable)e);
                throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), lydz.getLydzmc() + "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
            }
        }
        return resultModel;
    }
}

