/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.wxjj.event;

import cn.gtmap.hlw.core.domain.wxjj.WxjjEventService;
import cn.gtmap.hlw.core.domain.wxjj.model.WxjjParamsModel;
import cn.gtmap.hlw.core.domain.wxjj.model.WxjjResultModel;
import cn.gtmap.hlw.core.enums.JddmEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxjjDomainService {
    private static final Logger log = LoggerFactory.getLogger(WxjjDomainService.class);
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, WxjjEventService> eventServiceMap;

    public WxjjResultModel event(WxjjParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        GxYySqxx gxYySqxx = paramsModel.getGxYySqxx();
        BeanConvertUtil.setProperty((Object)paramsModel, (Object)gxYySqxx, (String)"qydm");
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), JddmEnum.JDDM_BDJS_5006.getCode(), paramsModel.getAnid(), gxYySqxx.getSqlx());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        WxjjResultModel resultModel = new WxjjResultModel();
        try {
            for (GxYyLydz lydz : lysjList.getLydzList()) {
                WxjjEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                eventService.doWork(paramsModel, resultModel);
                if (!StringUtils.isNotBlank((CharSequence)resultModel.getCode()) || StringUtils.equals((CharSequence)resultModel.getCode(), (CharSequence)ErrorEnum.SUCCESS.getCode())) continue;
                throw new BizException(resultModel.getCode(), resultModel.getMsg());
            }
        }
        catch (Exception e) {
            log.error("\u7ef4\u4fee\u57fa\u91d1\u7f34\u8d39\u62a5\u9519\uff1a", (Throwable)e);
            throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), e.getMessage());
        }
        return resultModel;
    }
}

