/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.workflow.event.query;

import cn.gtmap.hlw.core.domain.workflow.WorkFlowEventService;
import cn.gtmap.hlw.core.domain.workflow.model.query.ProcessAnRelModel;
import cn.gtmap.hlw.core.domain.workflow.model.query.ProcessBtnActionsResultModel;
import cn.gtmap.hlw.core.domain.workflow.model.query.ProcessFormResultModel;
import cn.gtmap.hlw.core.domain.workflow.model.query.ProcessResultModel;
import cn.gtmap.hlw.core.domain.workflow.model.query.WorkFlowParamsModel;
import cn.gtmap.hlw.core.domain.workflow.model.query.WorkFlowResultModel;
import cn.gtmap.hlw.core.enums.dict.RoleEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.enums.status.Status2Enum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyForm;
import cn.gtmap.hlw.core.model.GxYyFormModel;
import cn.gtmap.hlw.core.model.GxYyLysj;
import cn.gtmap.hlw.core.model.GxYyProcess;
import cn.gtmap.hlw.core.model.GxYyProcessAnRel;
import cn.gtmap.hlw.core.model.GxYyProcessLysjRel;
import cn.gtmap.hlw.core.model.GxYyResource;
import cn.gtmap.hlw.core.model.GxYySqxxProcess;
import cn.gtmap.hlw.core.model.GxYyZdSqlx;
import cn.gtmap.hlw.core.model.GxYyZdType;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyFormModelRepository;
import cn.gtmap.hlw.core.repository.GxYyFormRepository;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYyProcessAnRelRepository;
import cn.gtmap.hlw.core.repository.GxYyProcessLysjRelRepository;
import cn.gtmap.hlw.core.repository.GxYyProcessRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYyResourceRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxProcessRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdSqlxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdTypeRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.StrFormatter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkFlowQueryProcessAssembleEvent
implements WorkFlowEventService {
    private static final Logger log = LoggerFactory.getLogger(WorkFlowQueryProcessAssembleEvent.class);
    private static final Logger logger = LoggerFactory.getLogger(WorkFlowQueryProcessAssembleEvent.class);
    @Resource
    private GxYyProcessRepository gxYyProcessRepository;
    @Resource
    private GxYySqxxProcessRepository gxYySqxxProcessRepository;
    @Resource
    private GxYyFormRepository gxYyFormRepository;
    @Resource
    private GxYyResourceRepository gxYyResourceRepository;
    @Resource
    private GxYyFormModelRepository gxYyFormModelRepository;
    @Resource
    private GxYyProcessLysjRelRepository processLysjRelRepository;
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private GxYyProcessAnRelRepository gxYyProcessAnRelRepository;
    @Resource
    private GxYySqlxJdxxRepository gxYySqlxJdxxRepository;
    @Resource
    private GxYyZdTypeRepository gxYyZdTypeRepository;
    @Autowired
    private GxYyZdSqlxRepository zdSqlxRepository;
    @Autowired
    GxYySqxxRepository gxYySqxxRepository;
    @Resource
    private GxYyQlrRepository gxYyQlrRepository;
    @Autowired
    HlwPzPzxRepository hlwPzPzxRepository;

    public void doWork(WorkFlowParamsModel paramsModel, WorkFlowResultModel resultModel) {
        GxYyZdSqlx sqlx;
        List gxYyProcessList = StringUtils.equals((CharSequence)RoleEnum.BDGL_ROLE_GLY.getCode(), (CharSequence)paramsModel.getRoleId()) ? (StringUtils.isNotBlank((CharSequence)(sqlx = this.zdSqlxRepository.getSqlxBySqlxdm(paramsModel.getSqlxdm())).getSsyhlx()) ? this.gxYyProcessRepository.get(paramsModel.getSqlxdm(), paramsModel.getClientType(), paramsModel.getType(), sqlx.getSsyhlx()) : this.gxYyProcessRepository.get(paramsModel.getSqlxdm(), paramsModel.getClientType(), paramsModel.getType())) : this.gxYyProcessRepository.get(paramsModel.getSqlxdm(), paramsModel.getClientType(), paramsModel.getType(), paramsModel.getRoleId());
        List gxYySqxxProcessList = this.gxYySqxxProcessRepository.get(paramsModel.getSlbh(), paramsModel.getType());
        List<ProcessResultModel> processResultModelList = this.createProcessResultModel(gxYyProcessList, gxYySqxxProcessList);
        if (CollectionUtils.isNotEmpty(processResultModelList)) {
            this.getResourceForms(processResultModelList);
            this.getProcessLysj(processResultModelList);
        }
        resultModel.setSlbh(paramsModel.getSlbh());
        resultModel.setFunctionMenuId(paramsModel.getFunctionMenuId());
        resultModel.setSqlxdm(paramsModel.getSqlxdm());
        resultModel.setClientType(paramsModel.getClientType());
        WorkFlowQueryProcessAssembleEvent.sortListByStepId(processResultModelList);
        resultModel.setProcessList(processResultModelList);
        List gxYySqlxJdxxList = this.gxYySqlxJdxxRepository.getBySqlxdm(paramsModel.getSqlxdm());
        String sfczjdxx = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKey("yc.sfczjdxx.satus");
        if (StringUtils.equals((CharSequence)sfczjdxx, (CharSequence)Status2Enum.NO.getCode())) {
            resultModel.setSfczjdxx(Status2Enum.NO.getCode());
        } else {
            resultModel.setSfczjdxx(CollectionUtils.isEmpty((Collection)gxYySqlxJdxxList) ? Status2Enum.NO.getCode() : Status2Enum.YES.getCode());
        }
    }

    private void getProcessLysj(List<ProcessResultModel> processResultModelList) {
        if (CollectionUtils.isEmpty(processResultModelList)) {
            return;
        }
        List processIds = processResultModelList.stream().map(ProcessResultModel::getProcessId).filter(processId -> StringUtils.isNotBlank((CharSequence)processId)).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(processIds)) {
            return;
        }
        List processLysjList = this.processLysjRelRepository.getByProcessIds(processIds);
        if (CollectionUtils.isEmpty((Collection)processLysjList)) {
            return;
        }
        List<LysjModel> lysjModelList = this.toLysjModel(processLysjList);
        if (CollectionUtils.isEmpty(lysjModelList)) {
            return;
        }
        Map<String, List<LysjModel>> lysjMap = lysjModelList.stream().collect(Collectors.groupingBy(LysjModel::getProcessId));
        for (ProcessResultModel processResultModel : processResultModelList) {
            List<LysjModel> lysjRelList = lysjMap.get(processResultModel.getProcessId());
            this.getProcessBtn(processResultModel, lysjRelList);
        }
    }

    private void getProcessBtn(ProcessResultModel processResultModel, List<LysjModel> lysjRelList) {
        if (CollectionUtils.isEmpty(lysjRelList)) {
            return;
        }
        ArrayList before = Lists.newArrayList();
        Iterator<LysjModel> it = lysjRelList.iterator();
        while (it.hasNext()) {
            LysjModel lysjRel = it.next();
            if (!StringUtils.equals((CharSequence)"before", (CharSequence)lysjRel.getLysjzxsj())) continue;
            before.add(lysjRel);
            it.remove();
        }
        WorkFlowQueryProcessAssembleEvent.sortListByLysjzxsx(before);
        processResultModel.setLysjList((List)before);
        if (!CollectionUtils.isNotEmpty(lysjRelList)) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        lysjRelList.removeIf(lysjModel -> StringUtils.isBlank((CharSequence)lysjModel.getPaid()));
        Map<String, List<LysjModel>> lysjMap = lysjRelList.stream().collect(Collectors.groupingBy(LysjModel::getPaid));
        List processAnRelList = this.gxYyProcessAnRelRepository.listByProcessId(processResultModel.getProcessId());
        if (CollectionUtils.isNotEmpty((Collection)processAnRelList)) {
            for (GxYyProcessAnRel gxYyProcessAnRel : processAnRelList) {
                ProcessAnRelModel processAnRelModel = new ProcessAnRelModel();
                processAnRelModel.setPaid(gxYyProcessAnRel.getPaid());
                processAnRelModel.setEvent(gxYyProcessAnRel.getAnid());
                processAnRelModel.setName(gxYyProcessAnRel.getAnmc());
                processAnRelModel.setType(gxYyProcessAnRel.getAnlx());
                processAnRelModel.setAnsx(gxYyProcessAnRel.getAnsx());
                processAnRelModel.setAnkzpz(gxYyProcessAnRel.getAnkzpz());
                processAnRelModel.setSfzhan(gxYyProcessAnRel.getSfzhan());
                List<LysjModel> gxYyProcessLysjRelList = lysjMap.get(gxYyProcessAnRel.getPaid());
                WorkFlowQueryProcessAssembleEvent.sortListByLysjzxsx(gxYyProcessLysjRelList);
                if (CollectionUtils.isNotEmpty(gxYyProcessLysjRelList)) {
                    Map<String, List<LysjModel>> stringListMap = gxYyProcessLysjRelList.stream().collect(Collectors.groupingBy(LysjModel::getAnid));
                    ArrayList btnActionList = Lists.newArrayList();
                    for (String anid : stringListMap.keySet()) {
                        List<LysjModel> gxYyProcessLysjRels = stringListMap.get(anid);
                        LysjModel lysjModel2 = gxYyProcessLysjRels.get(0);
                        ProcessBtnActionsResultModel btnAction = new ProcessBtnActionsResultModel();
                        btnAction.setEvent(lysjModel2.getAnid());
                        btnAction.setName(lysjModel2.getAnmc());
                        btnAction.setType(lysjModel2.getAnlx());
                        btnAction.setAnsx(lysjModel2.getAnsx());
                        btnAction.setAnkzpz(lysjModel2.getAnkzpz());
                        List lysjModels = (List)CollUtil.filterNew(gxYyProcessLysjRels, item -> StringUtils.isNotBlank((CharSequence)item.getLysjdm()));
                        btnAction.setLysjList(lysjModels);
                        btnActionList.add(btnAction);
                    }
                    processAnRelModel.setZanList((List)btnActionList);
                }
                list.add(processAnRelModel);
            }
        }
        processResultModel.setBtnActions((List)list);
    }

    private List<LysjModel> toLysjModel(List<GxYyProcessLysjRel> gxYyProcessLysjRelList) {
        ArrayList<LysjModel> lysjModelList = new ArrayList<LysjModel>();
        if (CollectionUtils.isEmpty(gxYyProcessLysjRelList)) {
            return lysjModelList;
        }
        List lysjdms = gxYyProcessLysjRelList.stream().map(GxYyProcessLysjRel::getLysjdm).filter(lysjdm -> StringUtils.isNotBlank((CharSequence)lysjdm)).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(lysjdms)) {
            return lysjModelList;
        }
        List lysjList = this.lysjRepository.queryByLysjdmList(lysjdms);
        if (CollectionUtils.isEmpty((Collection)lysjList)) {
            logger.info("\u6839\u636e\u9886\u57df\u4e8b\u4ef6\u4ee3\u7801\uff1a{}\u53bbgx_yy_lysj\u8868\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u9886\u57df\u4e8b\u4ef6,\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", lysjdms);
            throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u83b7\u53d6\u9886\u57df\u4e8b\u4ef6\u5931\u8d25");
        }
        if (lysjdms.size() != lysjList.size()) {
            List list = lysjList.stream().map(GxYyLysj::getLysjdm).filter(lysjdm -> StringUtils.isNotBlank((CharSequence)lysjdm)).distinct().collect(Collectors.toList());
            lysjdms.removeAll(list);
            throw new BizException(ErrorEnum.NOT_FOUND.getCode(), StrFormatter.format((String)"\u9886\u57df\u4e8b\u4ef6\u4ee3\u7801\u7f3a\u5931\uff1a{}", (Object[])new Object[]{lysjdms}));
        }
        for (GxYyProcessLysjRel gxYyProcessLysjRel : gxYyProcessLysjRelList) {
            LysjModel lysjModel = (LysjModel)BeanConvertUtil.getBeanByJsonObj((Object)gxYyProcessLysjRel, LysjModel.class);
            for (GxYyLysj gxYyLysj : lysjList) {
                if (!StringUtils.equals((CharSequence)gxYyProcessLysjRel.getLysjdm(), (CharSequence)gxYyLysj.getLysjdm())) continue;
                lysjModel.setLysjdm(gxYyLysj.getLysjdm());
                lysjModel.setLysjjkdz(gxYyLysj.getLysjjkdz());
                lysjModel.setLysjjb(gxYyLysj.getLysjjb());
                lysjModel.setLysjmc(gxYyLysj.getLysjmc());
                lysjModel.setLysjlx(gxYyLysj.getLysjlx());
                lysjModel.setLysjlxmc(gxYyLysj.getLysjlxmc());
                lysjModel.setLysjsxl(gxYyLysj.getLysjsxl());
                lysjModel.setQdlyff(gxYyLysj.getQdlyff());
                lysjModel.setQdqqts(gxYyLysj.getQdqqts());
                lysjModel.setLysjzxsx(String.valueOf(gxYyProcessLysjRel.getLysjzxsx()));
                lysjModel.setLysjzxsj(String.valueOf(gxYyProcessLysjRel.getLysjzxsj()));
            }
            lysjModelList.add(lysjModel);
        }
        return lysjModelList;
    }

    private static void sortListByAnsx(List<ProcessBtnActionsResultModel> btnActionsResultModelList) {
        if (CollectionUtils.isEmpty(btnActionsResultModelList)) {
            return;
        }
        Comparator<ProcessBtnActionsResultModel> comparator = Comparator.comparing(ProcessBtnActionsResultModel::getAnsx, Comparator.nullsLast(Comparator.naturalOrder()));
        Collections.sort(btnActionsResultModelList, comparator);
    }

    private static void sortListByLysjzxsx(List<LysjModel> gxYyProcessLysjRelList) {
        if (CollectionUtils.isEmpty(gxYyProcessLysjRelList)) {
            return;
        }
        Comparator<LysjModel> comparator = Comparator.comparing(LysjModel::getLysjzxsx, Comparator.nullsLast(Comparator.naturalOrder()));
        Collections.sort(gxYyProcessLysjRelList, comparator);
    }

    private void getResourceForms(List<ProcessResultModel> processResultModelList) {
        if (CollectionUtils.isEmpty(processResultModelList)) {
            return;
        }
        List resourceIds = processResultModelList.stream().map(ProcessResultModel::getResourceId).filter(resourceId -> StringUtils.isNotBlank((CharSequence)resourceId)).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(resourceIds)) {
            return;
        }
        List resourceList = this.gxYyResourceRepository.getResourceByResourceIds(resourceIds);
        if (CollectionUtils.isEmpty((Collection)resourceList)) {
            return;
        }
        List formIds = resourceList.stream().map(GxYyResource::getFormid).filter(formid -> StringUtils.isNotBlank((CharSequence)formid)).distinct().collect(Collectors.toList());
        List formList = this.gxYyFormRepository.getForms(formIds);
        if (CollectionUtils.isEmpty((Collection)formList)) {
            return;
        }
        this.getFormModelJson(formList);
        List typeList = this.gxYyZdTypeRepository.list("BDFZ");
        Map<String, List<GxYyForm>> formMap = formList.stream().collect(Collectors.groupingBy(GxYyForm::getFormid));
        for (ProcessResultModel resultModel : processResultModelList) {
            for (GxYyResource gxYyResource : resourceList) {
                List formResultModelList;
                if (!StringUtils.equals((CharSequence)resultModel.getResourceId(), (CharSequence)gxYyResource.getResourceId()) || !StringUtils.isNotBlank((CharSequence)gxYyResource.getFormid()) || !CollectionUtils.isNotEmpty((Collection)(formResultModelList = BeanConvertUtil.getBeanListByJsonArray(formMap.get(gxYyResource.getFormid()), ProcessFormResultModel.class)))) continue;
                for (ProcessFormResultModel processFormResultModel : formResultModelList) {
                    GxYyZdType zdType;
                    if (!CollectionUtils.isNotEmpty((Collection)typeList) || (zdType = (GxYyZdType)CollUtil.findOne((Iterable)typeList, gxYyZdType -> StringUtils.equals((CharSequence)gxYyZdType.getDm(), (CharSequence)processFormResultModel.getBdfz()))) == null) continue;
                    processFormResultModel.setBdfzmc(zdType.getMc());
                }
                WorkFlowQueryProcessAssembleEvent.sortListByFormsxh(formResultModelList);
                resultModel.setFormList(formResultModelList);
            }
        }
    }

    private static void sortListByFormsxh(List<ProcessFormResultModel> formResultModelList) {
        if (CollectionUtils.isEmpty(formResultModelList)) {
            return;
        }
        Comparator<ProcessFormResultModel> comparator = Comparator.comparing(ProcessFormResultModel::getBdsxh, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ProcessFormResultModel::getSxh, Comparator.nullsLast(Comparator.naturalOrder()));
        Collections.sort(formResultModelList, comparator);
    }

    private void getFormModelJson(List<GxYyForm> formList) {
        ArrayList modelids = Lists.newArrayList();
        for (GxYyForm form : formList) {
            if (StringUtils.isBlank((CharSequence)form.getModelid()) && StringUtils.isBlank((CharSequence)form.getModeljson())) {
                logger.info("\u6839\u636eresource_id\uff1a{}\u7684\u8868\u5355\u4fe1\u606f\u65f6\uff0c\u53d1\u73b0form_Id\uff1a{}\u7684\u8868\u5355\u6570\u636e\u5b58\u5728Modelid\u548cModeljson\u540c\u65f6\u4e3a\u7a7a\u7684\u60c5\u51b5\uff0c\u8bf7\u6b63\u786e\u914d\u7f6e\u8be5\u6761\u6570\u636e\uff0c\u4e8c\u8005\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (Object)form.getModelid(), (Object)form.getModelid());
                throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u83b7\u53d6\u8868\u5355\u4fe1\u606f\u5931\u8d25\u3002");
            }
            if (!StringUtils.isBlank((CharSequence)form.getModeljson())) continue;
            modelids.add(form.getModelid());
        }
        if (CollectionUtils.isEmpty((Collection)modelids)) {
            return;
        }
        List formModelList = this.gxYyFormModelRepository.list((List)modelids);
        if (CollectionUtils.isEmpty((Collection)formModelList)) {
            logger.info("\u6839\u636eformModelList\uff1a{}\u53bbgx_yy_form_model\u67e5\u8be2\u6570\u636e\u65f6\u672a\u83b7\u53d6\u5230\u6570\u636e\uff0c\u5bfc\u81f4\u8868\u5355\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u6b63\u786e\u914d\u7f6e\u6570\u636e\u3002", (Object)formModelList);
            throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u83b7\u53d6\u8868\u5355\u4fe1\u606f\u5931\u8d25");
        }
        for (GxYyForm form : formList) {
            for (GxYyFormModel formModel : formModelList) {
                if (!StringUtils.equals((CharSequence)form.getModelid(), (CharSequence)formModel.getModelid())) continue;
                form.setModeljson(formModel.getModeljson());
            }
        }
    }

    private static void sortListByStepId(List<ProcessResultModel> processResultModelList) {
        if (CollectionUtils.isEmpty(processResultModelList)) {
            return;
        }
        Comparator<ProcessResultModel> comparator = Comparator.comparing(ProcessResultModel::getStepId, Comparator.nullsLast(Comparator.naturalOrder()));
        Collections.sort(processResultModelList, comparator);
    }

    private List<ProcessResultModel> createProcessResultModel(List<GxYyProcess> gxYyProcessList, List<GxYySqxxProcess> gxYySqxxProcessList) {
        ArrayList<ProcessResultModel> processResultModelList = new ArrayList<ProcessResultModel>();
        if (CollectionUtils.isEmpty(gxYyProcessList)) {
            return processResultModelList;
        }
        for (GxYyProcess gxYyProcess : gxYyProcessList) {
            ProcessResultModel processResultModel = new ProcessResultModel();
            processResultModel.setProcessId(gxYyProcess.getProcessId());
            processResultModel.setProcessName(gxYyProcess.getProcessName());
            processResultModel.setHref(gxYyProcess.getHref());
            processResultModel.setStepId(gxYyProcess.getStepId());
            processResultModel.setStepName(gxYyProcess.getStepName());
            processResultModel.setType(gxYyProcess.getType());
            processResultModel.setParentStepId(gxYyProcess.getParentStepId());
            processResultModel.setResourceId(gxYyProcess.getResourceId());
            processResultModel.setOrderNumber(String.valueOf(gxYyProcess.getOrderNumber()));
            processResultModel.setSfdhcdyszs(gxYyProcess.getSfdhcdyszs());
            processResultModel.setDescribes(gxYyProcess.getDescribes());
            processResultModel.setQlrlx(gxYyProcess.getQlrlx());
            if (CollectionUtils.isEmpty(gxYySqxxProcessList)) {
                processResultModel.setZxzt(Status2Enum.NO.getCode());
                processResultModel.setSfyc(gxYyProcess.getSfyc());
            } else {
                for (GxYySqxxProcess gxYySqxxProcess : gxYySqxxProcessList) {
                    if (!gxYyProcess.getProcessId().equals(gxYySqxxProcess.getProcessId())) continue;
                    processResultModel.setSfyc(gxYySqxxProcess.getSfyc());
                    processResultModel.setZxzt(gxYySqxxProcess.getZxzt());
                    break;
                }
            }
            processResultModelList.add(processResultModel);
        }
        return processResultModelList;
    }
}

