/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.workflow.event.query;

import cn.gtmap.hlw.core.domain.workflow.WorkFlowEventService;
import cn.gtmap.hlw.core.domain.workflow.model.query.SqlxModel;
import cn.gtmap.hlw.core.domain.workflow.model.query.WorkFlowParamsModel;
import cn.gtmap.hlw.core.domain.workflow.model.query.WorkFlowResultModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.enums.status.StatusEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.model.GxYyMenu;
import cn.gtmap.hlw.core.model.GxYyZdSqlx;
import cn.gtmap.hlw.core.repository.GxYyMenuRepository;
import cn.gtmap.hlw.core.repository.GxYyZdSqlxRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.core.util.dozer.DozerRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class WorkFlowQueryAssembelMenuEvent
implements WorkFlowEventService {
    @Resource
    private GxYyMenuRepository gxYyMenuRepository;
    @Resource
    private GxYyZdSqlxRepository gxYyZdSqlxRepository;
    @Resource
    private DozerRepository dozerRepository;

    public void doWork(WorkFlowParamsModel paramsModel, WorkFlowResultModel resultModel) {
        GxYyMenu gxYyMenu = null;
        if (StringUtils.isNotBlank((CharSequence)paramsModel.getFunctionMenuId())) {
            gxYyMenu = this.gxYyMenuRepository.getMenuByFunctionMenuId(paramsModel.getFunctionMenuId());
        } else {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{paramsModel.getSqlxdm(), paramsModel.getClientType()})) {
                throw new BizException((IError)ErrorEnum.PARAM_NULL);
            }
            gxYyMenu = this.gxYyMenuRepository.getMenuBySqlxAndClientType(paramsModel.getSqlxdm(), paramsModel.getClientType());
        }
        if (gxYyMenu == null) {
            throw new BizException((IError)ErrorEnum.NOT_FOUND);
        }
        if (StringUtils.isBlank((CharSequence)paramsModel.getSqlxdm())) {
            paramsModel.setSqlxdm(gxYyMenu.getSqlxId());
        } else if (!StringUtils.equals((CharSequence)paramsModel.getSqlxdm(), (CharSequence)gxYyMenu.getSqlxId())) {
            throw new BizException((IError)ErrorEnum.USER_NO_AUTH);
        }
        if (StringUtils.isBlank((CharSequence)paramsModel.getFunctionMenuId())) {
            gxYyMenu.getFunctionMenuId();
        }
        resultModel.setSqlxdm(gxYyMenu.getSqlxId());
        GxYyZdSqlx gxYyZdSqlx = this.gxYyZdSqlxRepository.getSqlxBySqlxdm(gxYyMenu.getSqlxId());
        if (gxYyZdSqlx == null) {
            throw new BizException(ApplyCodeEnum.APPLY_SQLX_NULL.getCode(), ApplyCodeEnum.APPLY_SQLX_NULL.getMsg());
        }
        resultModel.setSqlxmc(gxYyZdSqlx.getMc());
        if (StringUtils.equals((CharSequence)StatusEnum.TRUE.getCode(), (CharSequence)gxYyZdSqlx.getSfzh())) {
            List sqlxList = this.gxYyZdSqlxRepository.getZsqlxBySubdm(gxYyMenu.getSqlxId());
            if (CollectionUtils.isNotEmpty((Collection)sqlxList)) {
                List sqlxModels = this.dozerRepository.copyClassList((Collection)sqlxList, SqlxModel.class);
                resultModel.setSqlxList(sqlxModels);
            }
            resultModel.setSfzh(StatusEnum.TRUE.getCode());
        } else {
            SqlxModel sqlxModel = (SqlxModel)BeanConvertUtil.getBeanByJsonObj((Object)gxYyZdSqlx, SqlxModel.class);
            ArrayList sqlxModels = Lists.newArrayList();
            sqlxModels.add(sqlxModel);
            resultModel.setSqlxList((List)sqlxModels);
            resultModel.setSfzh(StatusEnum.FALSE.getCode());
        }
    }
}

