/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.workflow.event.query;

import cn.gtmap.hlw.core.domain.workflow.WorkFlowEventService;
import cn.gtmap.hlw.core.domain.workflow.model.query.WorkFlowParamsModel;
import cn.gtmap.hlw.core.domain.workflow.model.query.WorkFlowResultModel;
import cn.gtmap.hlw.core.enums.dict.RoleEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyBelongRoleRel;
import cn.gtmap.hlw.core.model.GxYyFunctionMenu;
import cn.gtmap.hlw.core.model.GxYyMenu;
import cn.gtmap.hlw.core.repository.GxYyBelongRoleRelRepository;
import cn.gtmap.hlw.core.repository.GxYyFunctionMenuRepository;
import cn.gtmap.hlw.core.repository.GxYyMenuRepository;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class WorkFlowQueryAccessPermissionsCheckEvent
implements WorkFlowEventService {
    @Resource
    private GxYyFunctionMenuRepository gxYyFunctionMenuRepository;
    @Resource
    private GxYyMenuRepository gxYyMenuRepository;
    @Resource
    private GxYyBelongRoleRelRepository gxYyBelongRoleRelRepository;

    public void doWork(WorkFlowParamsModel paramsModel, WorkFlowResultModel resultModel) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{paramsModel.getSqlxdm(), paramsModel.getClientType()})) {
            throw new BizException(ErrorEnum.PARAM_NULL.getCode(), ErrorEnum.PARAM_NULL.getMsg());
        }
        if (StringUtils.isBlank((CharSequence)paramsModel.getFunctionMenuId())) {
            GxYyMenu menu = this.gxYyMenuRepository.getMenuBySqlxAndClientType(paramsModel.getSqlxdm(), paramsModel.getClientType());
            if (menu == null) {
                throw new BizException(ErrorEnum.PARAM_NULL.getCode(), ErrorEnum.PARAM_NULL.getMsg());
            }
            paramsModel.setFunctionMenuId(menu.getFunctionMenuId());
        }
        List<GxYyFunctionMenu> menuList = Lists.newArrayList();
        if (StringUtils.equals((CharSequence)RoleEnum.BDGL_ROLE_GLY.getCode(), (CharSequence)paramsModel.getRoleId())) {
            menuList = this.gxYyFunctionMenuRepository.getFunctionMenuByFunctionMenuId(paramsModel.getFunctionMenuId());
        } else {
            GxYyBelongRoleRel belongRole;
            GxYyFunctionMenu gxYyFunctionMenu = this.gxYyFunctionMenuRepository.getFunctionMenuByFunctionMenuIdAndRoleId(paramsModel.getFunctionMenuId(), paramsModel.getRoleId());
            if (gxYyFunctionMenu == null && (belongRole = this.gxYyBelongRoleRelRepository.getBelongRoleRelByRoleId(paramsModel.getRoleId())) != null && StringUtils.isNotBlank((CharSequence)belongRole.getBelongRole())) {
                gxYyFunctionMenu = this.gxYyFunctionMenuRepository.getFunctionMenuByFunctionMenuIdAndRoleId(paramsModel.getFunctionMenuId(), belongRole.getBelongRole());
            }
            if (gxYyFunctionMenu != null) {
                menuList.add(gxYyFunctionMenu);
            }
        }
        if (CollectionUtils.isEmpty((Collection)menuList)) {
            throw new BizException(ErrorEnum.USER_NO_AUTH.getCode(), "\u6682\u65e0\u8bbf\u95ee\u6743\u9650!");
        }
        resultModel.setFunctionMenuId(paramsModel.getFunctionMenuId());
    }
}

