/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.workflow.event;

import cn.gtmap.hlw.core.domain.workflow.WorkFlowEventService;
import cn.gtmap.hlw.core.domain.workflow.model.query.WorkFlowParamsModel;
import cn.gtmap.hlw.core.domain.workflow.model.query.WorkFlowResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.login.enums.LoginStatusEnum;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkFlowQueryDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, WorkFlowEventService> eventServiceMap;

    public WorkFlowResultModel event(WorkFlowParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(LoginStatusEnum.LOGIN_LYSJDM_NOTNULL.getCode(), LoginStatusEnum.LOGIN_LYSJDM_NOTNULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), null);
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getCode(), LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getMsg());
        }
        WorkFlowResultModel resultModel = new WorkFlowResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            WorkFlowEventService workFlowEventService = this.eventServiceMap.get(lydz.getLydzsxl());
            workFlowEventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }
}

