/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.user.event.updatePwd;

import cn.gtmap.hlw.core.domain.user.UpdatePwdEventService;
import cn.gtmap.hlw.core.dto.user.user.UserParamsDTO;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyUser;
import cn.gtmap.hlw.core.model.LoginParamsModel;
import cn.gtmap.hlw.core.repository.GxYyUserRepository;
import cn.gtmap.hlw.domain.user.enums.UserErrorEnum;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdatePwdCheckUserEvent
implements UpdatePwdEventService {
    @Autowired
    private GxYyUserRepository gxYyUserRepository;

    public void doWork(UserParamsDTO paramsDTO) {
        GxYyUser user = null;
        if (StringUtils.isNotBlank((CharSequence)paramsDTO.getUserGuid())) {
            user = this.gxYyUserRepository.get(paramsDTO.getUserGuid());
        } else if (StringUtils.isBlank((CharSequence)paramsDTO.getUserGuid()) && StringUtils.isNotBlank((CharSequence)paramsDTO.getUserName())) {
            LoginParamsModel params = new LoginParamsModel();
            params.setLoginName(paramsDTO.getUserName());
            user = this.gxYyUserRepository.getUserByQueryParams(params);
        } else if (StringUtils.isNotBlank((CharSequence)paramsDTO.getUserZjid()) && StringUtils.isNotBlank((CharSequence)paramsDTO.getLxDh())) {
            user = this.gxYyUserRepository.getUserByZjidAndLxdh(paramsDTO.getUserZjid(), paramsDTO.getLxDh());
        } else if (StringUtils.isNotBlank((CharSequence)paramsDTO.getLxDh())) {
            user = this.gxYyUserRepository.getUserByLxdh(paramsDTO.getLxDh());
        }
        if (user == null) {
            throw new BizException(UserErrorEnum.NO_GET_USER.getCode(), UserErrorEnum.NO_GET_USER.getMsg());
        }
        paramsDTO.setUserGuid(user.getUserGuid());
    }
}

