/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.user.event.register;

import cn.gtmap.estateplat.register.common.util.PublicUtil;
import cn.gtmap.hlw.core.domain.user.RegisterEventService;
import cn.gtmap.hlw.core.dto.user.user.UserRegisterDTO;
import cn.gtmap.hlw.core.dto.user.user.UserRegisterResultDTO;
import cn.gtmap.hlw.core.enums.dict.RoleEnum;
import cn.gtmap.hlw.core.enums.dict.ZjlxEnum;
import cn.gtmap.hlw.core.enums.status.Status2Enum;
import cn.gtmap.hlw.core.enums.status.Status3Enum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyUser;
import cn.gtmap.hlw.core.model.GxYyUserRoleRel;
import cn.gtmap.hlw.core.repository.GxYyUserRepository;
import cn.gtmap.hlw.core.repository.GxYyUserRoleRelRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.encryption.md5.Md5;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.gtmap.hlw.domain.login.enums.LoginStatusEnum;
import com.gtis.common.util.UUIDGenerator;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RegisterCheckUserEvent
implements RegisterEventService {
    @Autowired
    private GxYyUserRepository gxYyUserRepository;
    @Autowired
    private GxYyUserRoleRelRepository gxYyUserRoleRelRepository;
    @Autowired
    private RedisRepository redisRepository;
    @Autowired
    private HlwPzPzxRepository hlwPzPzxRepository;

    public void doWork(UserRegisterDTO registerDTO, UserRegisterResultDTO resultDTO) {
        String userId;
        GxYyUser gxYyUser = this.gxYyUserRepository.getUserByLxdh(registerDTO.getLxdh());
        if (gxYyUser != null) {
            throw new BizException(LoginStatusEnum.USER_EXIST.getCode(), LoginStatusEnum.USER_EXIST.getMsg());
        }
        gxYyUser = this.gxYyUserRepository.getUserByUserZjId(registerDTO.getUserZjid());
        if (gxYyUser != null) {
            throw new BizException(LoginStatusEnum.USER_EXIST.getCode(), LoginStatusEnum.USER_EXIST.getMsg());
        }
        GxYyUser user = new GxYyUser();
        String userPwd = registerDTO.getUserPwd();
        if (StringUtils.isNotBlank((CharSequence)userPwd)) {
            String key = StringUtil.toString((Object)this.redisRepository.get("md5.salt"));
            if (StringUtils.isBlank((CharSequence)key)) {
                key = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKey("md5.salt");
            }
            String md5PassWord = Md5.sign((String)Sm2lib.decode((String)userPwd), (String)key, (String)String.valueOf(StandardCharsets.UTF_8));
            user.setUserPwd(md5PassWord);
        }
        if (StringUtils.isBlank((CharSequence)(userId = registerDTO.getUserId()))) {
            userId = StringUtil.hex32();
        }
        user.setUserGuid(userId);
        user.setUserName("yhm" + UUIDGenerator.generate());
        user.setRealName(registerDTO.getRealName());
        user.setUserZjid(registerDTO.getUserZjid());
        user.setZjType(ZjlxEnum.SFZJZL_SFZ.getCode());
        user.setSfyz(Status3Enum.YES.getCode());
        user.setYzfs("0");
        user.setLxDh(registerDTO.getLxdh());
        user.setCreateDate(new Date());
        user.setIsValid(Integer.valueOf(Integer.parseInt(Status2Enum.YES.getCode())));
        user.setZcly(registerDTO.getZcly());
        this.gxYyUserRepository.save(user);
        GxYyUserRoleRel gxYyUserRoleRel = new GxYyUserRoleRel();
        gxYyUserRoleRel.setUserId(userId);
        gxYyUserRoleRel.setRoleId(RoleEnum.BDGL_ROLE_GR.getCode());
        gxYyUserRoleRel.setUserRoleRelId(PublicUtil.hex32());
        this.gxYyUserRoleRelRepository.save(gxYyUserRoleRel);
        resultDTO.setUserId(userId);
    }
}

