/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.user.event;

import cn.gtmap.hlw.core.domain.user.UpdatePwdEventService;
import cn.gtmap.hlw.core.dto.user.user.UserParamsDTO;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.login.enums.LoginStatusEnum;
import java.util.Collection;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserUpdatePwdDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, UpdatePwdEventService> eventServiceMap;

    public void update(@NotNull UserParamsDTO paramsDTO) {
        if (StringUtils.isBlank((CharSequence)paramsDTO.getLysjdm())) {
            throw new BizException(LoginStatusEnum.LOGIN_LYSJDM_NOTNULL.getCode(), LoginStatusEnum.LOGIN_LYSJDM_NOTNULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsDTO.getLysjdm(), null);
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getCode(), LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getMsg());
        }
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            UpdatePwdEventService updatePwdEventService = this.eventServiceMap.get(lydz.getLydzsxl());
            updatePwdEventService.doWork(paramsDTO);
        }
    }
}

