/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.third.mk.event;

import cn.gtmap.hlw.core.domain.third.mk.MkEventService;
import cn.gtmap.hlw.core.dto.mk.MkParamDTO;
import cn.gtmap.hlw.core.dto.mk.MkResultDTO;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class MkDomainService {
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, MkEventService> eventServiceMap;

    public MkResultDTO event(MkParamDTO paramsDTO) {
        if (StringUtils.isBlank((CharSequence)paramsDTO.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsDTO.getLysjdm(), paramsDTO.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        MkResultDTO mkResultDTO = new MkResultDTO();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            MkEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsDTO, mkResultDTO);
        }
        return mkResultDTO;
    }
}

