/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.third.dzzz.event;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.domain.third.dzzz.BdcDzzzFyQueryEventService;
import cn.gtmap.hlw.core.domain.third.dzzz.model.BdcDzzzParamModel;
import cn.gtmap.hlw.core.domain.third.dzzz.model.BdcDzzzResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DzzzFyQueryDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, BdcDzzzFyQueryEventService> eventServiceMap;

    public PageInfo<BdcDzzzResultModel> event(BdcDzzzParamModel paramModel) {
        if (StringUtils.isBlank((CharSequence)paramModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramModel.getLysjdm(), paramModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        PageInfo bdcDzzzResultModelPageInfo = new PageInfo();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            BdcDzzzFyQueryEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramModel, bdcDzzzResultModelPageInfo);
        }
        return bdcDzzzResultModelPageInfo;
    }
}

