/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sw.event.hs.kunsan;

import cn.gtmap.hlw.core.domain.fj.FjEventService;
import cn.gtmap.hlw.core.dto.sw.yxzl.KsSwFjxxParamsDTO;
import cn.gtmap.hlw.core.dto.sw.yxzl.KsSwGrid;
import cn.gtmap.hlw.core.dto.sw.yxzl.KsSwWjxxGrid;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.enums.qlr.QlrTypeEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.model.GxYyFjxm;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYyZdDz;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYyZdDzRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.hutool.core.codec.Base64Encoder;
import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KsSwAssembleFjxxEvent {
    private static final Logger log = LoggerFactory.getLogger(KsSwAssembleFjxxEvent.class);
    @Autowired
    GxYyFjxmRepository gxYyFjxmRepository;
    @Autowired
    GxYyFjxxRepository gxYyFjxxRepository;
    @Autowired
    GxYyZdDzRepository gxYyZdDzRepository;
    @Autowired
    FjEventService fjEventService;
    @Autowired
    GxYyQlrRepository gxYyQlrRepository;
    @Autowired
    RedisRepository redisRepository;

    public KsSwGrid assembleFjxxList(GxYySqxx gxYySqxx) {
        KsSwGrid ksSwGrid = new KsSwGrid();
        KsSwWjxxGrid ksSwWjxxGrid = new KsSwWjxxGrid();
        ArrayList list = Lists.newArrayList();
        List gxYyFjxmList = this.gxYyFjxmRepository.getBySlbh(gxYySqxx.getSlbh());
        if (CollectionUtils.isNotEmpty((Collection)gxYyFjxmList)) {
            List qlrList = this.gxYyQlrRepository.getBySqidAndQlrlx(gxYySqxx.getSqid(), QlrTypeEnum.QLRLX_QLR.getCode());
            List ywrList = this.gxYyQlrRepository.getBySqidAndQlrlx(gxYySqxx.getSqid(), QlrTypeEnum.QLRLX_YWR.getCode());
            List xmidList = gxYyFjxmList.stream().map(GxYyFjxm::getXmid).collect(Collectors.toList());
            List gxYyFjxxList = this.gxYyFjxxRepository.getByFjxmids(xmidList);
            String tsFjlx = StringUtil.toString((Object)this.redisRepository.get("yc.tssw.fjlx"));
            if (StringUtils.isBlank((CharSequence)tsFjlx)) {
                throw new BizException((IError)ErrorEnum.PZX_NOT_EXISTS, "\u63a8\u9001\u7a0e\u52a1\u9644\u4ef6\u7c7b\u578b\u672a\u914d\u7f6e");
            }
            List<String> fjlxList = Arrays.asList(tsFjlx.split(","));
            for (GxYyFjxx fjxx : gxYyFjxxList) {
                GxYyQlr gxYyQlr;
                if (!fjlxList.contains(fjxx.getFjlx())) continue;
                String zjlybz = "";
                String nsrmc = "";
                String nsrzjh = "";
                String path = this.fjEventService.getFilePath(fjxx);
                File file = FileUtil.file((String)path);
                if (!file.exists()) continue;
                String fjlx = fjxx.getFjlx();
                KsSwFjxxParamsDTO paramsDTO = new KsSwFjxxParamsDTO();
                GxYyZdDz gxYyZdDz = this.gxYyZdDzRepository.getRedisGxYyZdDzByZdbmAndDm("SZSW", "YXWJLX", fjlx);
                String fjlxmc = "";
                if (gxYyZdDz != null) {
                    paramsDTO.setWjBm(gxYyZdDz.getSjdm());
                    fjlxmc = gxYyZdDz.getSjmc();
                }
                if (StringUtils.contains((CharSequence)fjlxmc, (CharSequence)"\u627f\u53d7\u65b9\u4fe1\u606f\u6587\u4ef6")) {
                    zjlybz = "0";
                    if (CollectionUtils.isNotEmpty((Collection)qlrList)) {
                        gxYyQlr = (GxYyQlr)qlrList.get(0);
                        nsrmc = gxYyQlr.getQlrmc();
                        nsrzjh = gxYyQlr.getQlrzjh();
                    }
                }
                if (StringUtils.contains((CharSequence)fjlxmc, (CharSequence)"\u8f6c\u8ba9\u65b9\u4fe1\u606f\u6587\u4ef6")) {
                    zjlybz = "1";
                    if (CollectionUtils.isNotEmpty((Collection)ywrList)) {
                        gxYyQlr = (GxYyQlr)ywrList.get(0);
                        nsrmc = gxYyQlr.getQlrmc();
                        nsrzjh = gxYyQlr.getQlrzjh();
                    }
                }
                if (StringUtils.contains((CharSequence)fjlxmc, (CharSequence)"\u623f\u5c4b\u4fe1\u606f\u6587\u4ef6")) {
                    zjlybz = "2";
                }
                paramsDTO.setNsrmc(nsrmc);
                paramsDTO.setZjHm(nsrzjh);
                paramsDTO.setZjlybz(zjlybz);
                paramsDTO.setWjMc(fjxx.getFjmc());
                paramsDTO.setUuid(fjxx.getFjid());
                log.info("assembleFjxxList:" + JSON.toJSONString((Object)paramsDTO));
                paramsDTO.setWjBase64(Base64Encoder.encode((byte[])FileUtil.readBytes((File)file)));
                list.add(paramsDTO);
            }
        }
        ksSwWjxxGrid.setRow((List)list);
        ksSwGrid.setWjxxGrid(ksSwWjxxGrid);
        return ksSwGrid;
    }
}

