/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sw.event.hs.anhui;

import cn.gtmap.hlw.core.domain.sw.SwHsEventService;
import cn.gtmap.hlw.core.domain.sw.model.hs.SwHsParamsModel;
import cn.gtmap.hlw.core.domain.sw.model.hs.SwHsResultModel;
import cn.gtmap.hlw.core.dto.sw.hs.AhSwHsQueryDTO;
import cn.gtmap.hlw.core.dto.sw.hs.zlf.ah.AhSwHsZlfQueryDTO;
import cn.gtmap.hlw.core.dto.sw.hs.zlf.ah.FpxxDTO;
import cn.gtmap.hlw.core.dto.sw.hs.zlf.ah.JtcyxxDTO;
import cn.gtmap.hlw.core.dto.sw.hs.zlf.ah.QlrxxDTO;
import cn.gtmap.hlw.core.enums.dict.GyfsEnum;
import cn.gtmap.hlw.core.enums.dict.JyfsEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.enums.qlr.QlrCodeEnum;
import cn.gtmap.hlw.core.enums.qlr.QlrTypeEnum;
import cn.gtmap.hlw.core.enums.status.Status2Enum;
import cn.gtmap.hlw.core.enums.sw.NsrlxEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyFwxx;
import cn.gtmap.hlw.core.model.GxYyHtQlr;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYyQlrJtcy;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYySqxxFpxx;
import cn.gtmap.hlw.core.model.GxYySqxxHtxx;
import cn.gtmap.hlw.core.model.GxYySqxxSw;
import cn.gtmap.hlw.core.model.GxYyUser;
import cn.gtmap.hlw.core.repository.GxYyFwxxRepository;
import cn.gtmap.hlw.core.repository.GxYyHtQlrRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrJtcyRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxFpxxRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxHtxxRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxSwRepository;
import cn.gtmap.hlw.core.repository.GxYyUserRepository;
import cn.gtmap.hlw.core.repository.GxYyZdTypeRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.core.util.date.DateUtils;
import cn.gtmap.hlw.domain.dict.event.GxYyZdDzEvent;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AhSwHsZlfAssembleParamsEvent
implements SwHsEventService {
    private static final Logger log = LoggerFactory.getLogger(AhSwHsZlfAssembleParamsEvent.class);
    @Autowired
    GxYySqxxSwRepository gxYySqxxSwRepository;
    @Autowired
    GxYySqxxRepository gxYySqxxRepository;
    @Autowired
    GxYyQlrRepository gxYyQlrRepository;
    @Autowired
    GxYySqxxHtxxRepository gxYySqxxHtxxRepository;
    @Autowired
    GxYyFwxxRepository gxYyFwxxRepository;
    @Autowired
    GxYyQlrJtcyRepository gxYyQlrJtcyRepository;
    @Autowired
    GxYyZdDzEvent gxYyZdDzEvent;
    @Autowired
    GxYyZdTypeRepository gxYyZdTypeRepository;
    @Autowired
    GxYyUserRepository gxYyUserRepository;
    @Resource
    GxYySqxxFpxxRepository gxYySqxxFpxxRepository;
    @Autowired
    HlwPzPzxRepository hlwPzPzxRepository;
    @Autowired
    GxYyHtQlrRepository gxYyHtQlrRepository;

    public void doWork(SwHsParamsModel paramsModel, SwHsResultModel resultModel) {
        GxYySqxx gxYySqxx = paramsModel.getGxYySqxx();
        GxYySqxxSw gxYySqxxSw = null;
        List swList = this.gxYySqxxSwRepository.list(gxYySqxx.getSlbh());
        if (CollectionUtils.isNotEmpty((Collection)swList)) {
            gxYySqxxSw = (GxYySqxxSw)swList.get(0);
        }
        List qlrList = this.gxYyQlrRepository.list(gxYySqxx.getSqid());
        List htQlrList = this.gxYyHtQlrRepository.list(gxYySqxx.getSqid());
        log.info("qlrList:" + JSON.toJSONString((Object)qlrList));
        log.info("htQlrList:" + JSON.toJSONString((Object)htQlrList));
        if (CollectionUtils.isNotEmpty((Collection)htQlrList)) {
            ArrayList list = Lists.newArrayList();
            for (GxYyQlr gxYyQlr : qlrList) {
                for (GxYyHtQlr gxYyHtQlr : htQlrList) {
                    if (!StringUtils.equals((CharSequence)gxYyQlr.getQlrzjh(), (CharSequence)gxYyHtQlr.getQlrzjh()) || !StringUtils.equals((CharSequence)gxYyQlr.getQlrlx(), (CharSequence)gxYyHtQlr.getQlrlx())) continue;
                    if (StringUtils.isNotBlank((CharSequence)gxYyHtQlr.getGyfs())) {
                        gxYyQlr.setGyfs(gxYyHtQlr.getGyfs());
                    }
                    if (StringUtils.isNotBlank((CharSequence)gxYyHtQlr.getQlbl())) {
                        gxYyQlr.setQlbl(gxYyHtQlr.getQlbl());
                    }
                    list.add(gxYyQlr);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                qlrList.clear();
                qlrList.addAll(list);
            }
        }
        if (CollectionUtils.isEmpty((Collection)qlrList)) {
            throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u672a\u67e5\u8be2\u5230\u8be5\u6743\u5229\u4eba\u4fe1\u606f");
        }
        GxYySqxxHtxx gxYySqxxHtxx = this.gxYySqxxHtxxRepository.get(gxYySqxx.getSqid());
        if (gxYySqxxHtxx == null) {
            throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u672a\u67e5\u8be2\u5230\u8be5\u5408\u540c\u4fe1\u606f");
        }
        GxYyFwxx gxYyFwxx = this.gxYyFwxxRepository.get(gxYySqxx.getSqid());
        if (gxYyFwxx == null) {
            throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u672a\u67e5\u8be2\u5230\u8be5\u623f\u5c4b\u4fe1\u606f");
        }
        AhSwHsZlfQueryDTO queryDTO = this.assembleQueryDTO(gxYySqxx, qlrList, gxYySqxxHtxx, gxYyFwxx, gxYySqxxSw, paramsModel);
        paramsModel.setQueryDTO((AhSwHsQueryDTO)queryDTO);
        paramsModel.setGxYySqxx(gxYySqxx);
    }

    private AhSwHsZlfQueryDTO assembleQueryDTO(GxYySqxx gxYySqxx, List<GxYyQlr> gxYyQlrList, GxYySqxxHtxx gxYySqxxHtxx, GxYyFwxx gxYyFwxx, GxYySqxxSw gxYySqxxSw, SwHsParamsModel paramsModel) {
        List fpxxList;
        String jyjg;
        List<GxYyQlr> qlrList = gxYyQlrList.stream().filter(qlr -> StringUtils.equals((CharSequence)QlrTypeEnum.QLRLX_QLR.getCode(), (CharSequence)qlr.getQlrlx())).collect(Collectors.toList());
        List ywrList = gxYyQlrList.stream().filter(qlr -> StringUtils.equals((CharSequence)QlrTypeEnum.QLRLX_YWR.getCode(), (CharSequence)qlr.getQlrlx())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ywrList)) {
            ywrList = this.gxYyQlrRepository.getBySqidAndQlrlx(gxYySqxx.getSqid(), QlrTypeEnum.QLRLX_YWR.getCode());
        }
        AhSwHsZlfQueryDTO queryDTO = new AhSwHsZlfQueryDTO();
        queryDTO.setBdcqzh(gxYySqxx.getFczh());
        queryDTO.setBdcdyh(gxYySqxx.getBdcdyh());
        queryDTO.setXzqhDm(StringUtils.substring((String)gxYySqxx.getBdcdyh(), (int)0, (int)6));
        queryDTO.setXzqhMc(StringUtils.substring((String)gxYySqxx.getBdcdyh(), (int)0, (int)6));
        queryDTO.setJdxzDm(StringUtils.substring((String)gxYySqxx.getBdcdyh(), (int)0, (int)6));
        queryDTO.setJdxzMc(StringUtils.substring((String)gxYySqxx.getBdcdyh(), (int)0, (int)6));
        queryDTO.setXqmc(gxYyFwxx.getXqmc());
        queryDTO.setFwwzdz(gxYySqxx.getZl());
        queryDTO.setJzmj(gxYyFwxx.getJzmj());
        queryDTO.setTnmj(StringUtils.isNotBlank((CharSequence)gxYyFwxx.getSctnmj()) ? gxYyFwxx.getSctnmj() : gxYyFwxx.getJzmj());
        queryDTO.setZlc(gxYyFwxx.getFwzcs());
        queryDTO.setSzlc(gxYyFwxx.getFwszc());
        queryDTO.setFwzh(gxYyFwxx.getFwzh());
        queryDTO.setDyh(gxYyFwxx.getFwdyh());
        queryDTO.setFjh(gxYyFwxx.getFwfh());
        queryDTO.setJzjglxDm(gxYyFwxx.getFwjg());
        queryDTO.setJzjglxMc(gxYyFwxx.getFwjg());
        queryDTO.setCx(gxYyFwxx.getFwcxdm());
        queryDTO.setJznd(gxYyFwxx.getJznf());
        queryDTO.setJyrq(DateUtils.dateToStr((String)"yyyy-MM-dd"));
        queryDTO.setBdcFwyt(gxYyFwxx.getFwyt());
        queryDTO.setFwyt(gxYyFwxx.getFwyt());
        queryDTO.setFclxDm(gxYyFwxx.getFwlx());
        queryDTO.setFclxMc(gxYyFwxx.getFwlx());
        queryDTO.setFcjyfsDm(gxYyFwxx.getQszyfs());
        queryDTO.setFcjyfsMc(gxYyFwxx.getQszyfs());
        String string = jyjg = gxYySqxx.getJyjg() != null ? BigDecimal.valueOf(gxYySqxx.getJyjg()).toString() : "";
        if (StringUtils.equals((CharSequence)gxYyFwxx.getQszyfs(), (CharSequence)JyfsEnum.JYFS_CQAZBC.getCode())) {
            queryDTO.setJyjg("0");
            queryDTO.setCqazbcbj("1");
        } else {
            queryDTO.setJyjg(jyjg);
        }
        queryDTO.setSldh(gxYySqxx.getSlbh());
        queryDTO.setHtbh(gxYySqxx.getMmhth());
        queryDTO.setHtje(gxYySqxxHtxx.getHtje() != null ? BigDecimal.valueOf(gxYySqxxHtxx.getHtje()).toString() : "");
        queryDTO.setHtqdrq(this.parseDate(gxYySqxxHtxx.getHtqdrq()));
        queryDTO.setHtjgsfhs(Status2Enum.YES.getCode());
        if (gxYySqxxHtxx.getDj() != null) {
            queryDTO.setJydj(BigDecimal.valueOf(gxYySqxxHtxx.getDj()).toString());
        } else if (gxYySqxx.getJyjg() != null && StringUtils.isNotBlank((CharSequence)gxYyFwxx.getJzmj())) {
            double dj = NumberUtil.div((Double)gxYySqxx.getJyjg(), (Double)Double.valueOf(gxYyFwxx.getJzmj()), (int)2);
            queryDTO.setJydj(BigDecimal.valueOf(dj).toString());
        }
        queryDTO.setZzsse(gxYySqxxHtxx.getZzsje() != null ? BigDecimal.valueOf(gxYySqxxHtxx.getZzsje()).toString() : "");
        queryDTO.setBhzzsje(gxYySqxxHtxx.getBhzzsje() != null ? BigDecimal.valueOf(gxYySqxxHtxx.getBhzzsje()).toString() : "");
        GxYyUser gxYyUser = this.gxYyUserRepository.get(gxYySqxx.getCreateUserid());
        queryDTO.setJbrxm(gxYyUser != null ? gxYyUser.getRealName() : "");
        String jbrdh = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKeyAndQydm("ahsw.hs.jbrdh." + StringUtils.substring((String)gxYySqxx.getBdcdyh(), (int)0, (int)9), gxYySqxx.getQydm());
        if (StringUtils.isBlank((CharSequence)jbrdh)) {
            jbrdh = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKeyAndQydm("ahsw.hs.jbrdh", gxYySqxx.getQydm());
        }
        queryDTO.setJbrdh(jbrdh);
        queryDTO.setFwnm(gxYySqxx.getBdcdyh());
        if (CollectionUtils.isNotEmpty((Collection)ywrList)) {
            GxYyQlr gxYyQlr = (GxYyQlr)ywrList.get(0);
            queryDTO.setKfsmc(gxYyQlr.getQlrmc());
            queryDTO.setKfsnsrsbh(gxYyQlr.getQlrzjh());
        }
        queryDTO.setFsmj("0");
        queryDTO.setFsje("0");
        queryDTO.setFjxx(gxYySqxx.getFj());
        BeanConvertUtil.nullToEmpty((Object)queryDTO);
        queryDTO = this.gxYyZdDzEvent.convertOurToThird(queryDTO, "AHSSW");
        if (gxYySqxxSw != null && StringUtils.isNotBlank((CharSequence)gxYySqxxSw.getJdxzdm())) {
            queryDTO.setJdxzDm(gxYySqxxSw.getJdxzdm());
            queryDTO.setJdxzMc(this.gxYyZdTypeRepository.getRedisUtilsDictMcByDm("SWJDXZ", gxYySqxxSw.getJdxzdm()));
        }
        queryDTO.setSrfjtcylb(this.assembleSrfJtcyxx(qlrList));
        queryDTO.setSrfxxlb(this.assembleSrfxx(qlrList, gxYySqxx, gxYyFwxx));
        if (paramsModel.getSfzh().booleanValue()) {
            queryDTO.setMergeid(gxYySqxx.getSlbh() + "-1");
        }
        if (CollectionUtils.isNotEmpty((Collection)(fpxxList = this.gxYySqxxFpxxRepository.listBySqid(gxYySqxx.getSqid())))) {
            ArrayList fpList = Lists.newArrayList();
            for (GxYySqxxFpxx gxYySqxxFpxx : fpxxList) {
                FpxxDTO fpxxDTO = new FpxxDTO();
                fpxxDTO.setFpdm(gxYySqxxFpxx.getFpdm());
                fpxxDTO.setFphm(gxYySqxxFpxx.getFphm());
                fpxxDTO.setKprq(gxYySqxxFpxx.getKprq());
                fpList.add(fpxxDTO);
            }
            queryDTO.setFpxx((List)fpList);
        }
        queryDTO.setSbje(gxYySqxxHtxx.getHtje() != null ? BigDecimal.valueOf(gxYySqxxHtxx.getHtje()).toString() : "");
        queryDTO.setCnbz("1");
        return queryDTO;
    }

    private String parseDate(String date) {
        return DateUtils.dateToStr((Date)(StringUtils.isNotBlank((CharSequence)date) ? DateUtils.strToDate((String)date, (String)"yyyy-MM-dd HH:mm:ss") : new Date()), (String)"yyyy-MM-dd");
    }

    private List<QlrxxDTO> assembleSrfxx(List<GxYyQlr> qlrList, GxYySqxx gxYySqxx, GxYyFwxx gxYyFwxx) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(qlrList)) {
            int index = 0;
            for (GxYyQlr gxYyQlr : qlrList) {
                QlrxxDTO srfxxDTO = new QlrxxDTO();
                srfxxDTO.setNsrmc(gxYyQlr.getQlrmc());
                srfxxDTO.setNsrlx(StringUtils.equals((CharSequence)QlrCodeEnum.QLRZL_GR.getCode(), (CharSequence)gxYyQlr.getGxrzldm()) ? NsrlxEnum.GR.getCode() : NsrlxEnum.QY.getCode());
                srfxxDTO.setSfzjlxDm(gxYyQlr.getQlrsfzjzl());
                srfxxDTO.setSfzjlxMc(gxYyQlr.getQlrsfzjzl());
                srfxxDTO.setSfzjhm(gxYyQlr.getQlrzjh());
                srfxxDTO.setLxdh(gxYyQlr.getQlrlxdh());
                String qlrfwtcjMinus = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKeyAndQydm("ahsw.hs.qlrfwtcj.minus", gxYySqxx.getQydm());
                if (StringUtils.equals((CharSequence)qlrfwtcjMinus, (CharSequence)"true") && StringUtils.equals((CharSequence)gxYyQlr.getQlrlx(), (CharSequence)QlrTypeEnum.QLRLX_QLR.getCode())) {
                    srfxxDTO.setFwtc(StringUtils.isNotBlank((CharSequence)gxYyQlr.getFwtc()) ? String.valueOf(Integer.parseInt(gxYyQlr.getFwtc()) - 1) : "");
                    String sbfwtc = StringUtils.isNotBlank((CharSequence)gxYyQlr.getSbfwtc()) ? String.valueOf(Integer.parseInt(gxYyQlr.getSbfwtc()) - 1) : "";
                    srfxxDTO.setSbFwtc(StringUtils.isNotBlank((CharSequence)sbfwtc) ? sbfwtc : srfxxDTO.getFwtc());
                } else {
                    srfxxDTO.setFwtc(gxYyQlr.getFwtc());
                    srfxxDTO.setSbFwtc(StringUtils.isNotBlank((CharSequence)gxYyQlr.getSbfwtc()) ? gxYyQlr.getSbfwtc() : gxYyQlr.getFwtc());
                }
                srfxxDTO.setGjDm("156");
                srfxxDTO.setZcqrbz(index == 0 ? "1" : "0");
                srfxxDTO.setGyfs(GyfsEnum.getMsg((String)gxYyQlr.getGyfs()));
                if (StringUtils.equals((CharSequence)gxYyQlr.getQlrlx(), (CharSequence)QlrTypeEnum.QLRLX_QLR.getCode()) && StringUtils.equals((CharSequence)gxYyFwxx.getQszyfs(), (CharSequence)JyfsEnum.JYFS_CQAZBC.getCode())) {
                    srfxxDTO.setCqazbcje(gxYySqxx.getJyjg() != null ? BigDecimal.valueOf(gxYySqxx.getJyjg()).toString() : "");
                }
                if (StringUtils.equals((CharSequence)gxYyQlr.getGyfs(), (CharSequence)"0")) {
                    srfxxDTO.setJyfe("1");
                    srfxxDTO.setSzfe("1");
                } else if (StringUtils.equals((CharSequence)gxYyQlr.getGyfs(), (CharSequence)"1")) {
                    srfxxDTO.setJyfe("0.5");
                    srfxxDTO.setSzfe("0.5");
                } else if (StringUtils.equals((CharSequence)gxYyQlr.getGyfs(), (CharSequence)"2")) {
                    String qlbl = NumberUtil.div((String)gxYyQlr.getQlbl(), (String)"100", (int)2).toString();
                    srfxxDTO.setJyfe(qlbl);
                    srfxxDTO.setSzfe(qlbl);
                }
                if (StringUtils.isNotBlank((CharSequence)gxYyQlr.getXyzfzl())) {
                    srfxxDTO.setFcdz(Arrays.asList(gxYyQlr.getXyzfzl().split(",")));
                }
                BeanConvertUtil.nullToEmpty((Object)srfxxDTO);
                list.add(this.gxYyZdDzEvent.convertOurToThird(srfxxDTO, "AHSSW"));
                ++index;
            }
        }
        return list;
    }

    private List<JtcyxxDTO> assembleSrfJtcyxx(List<GxYyQlr> qlrList) {
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(qlrList)) {
            for (GxYyQlr gxYyQlr : qlrList) {
                List jtcyList = this.gxYyQlrJtcyRepository.getByQlrid(gxYyQlr.getQlrid());
                if (!CollectionUtils.isNotEmpty((Collection)jtcyList)) continue;
                for (GxYyQlrJtcy gxYyQlrJtcy : jtcyList) {
                    JtcyxxDTO srfjtcyDTO = new JtcyxxDTO();
                    srfjtcyDTO.setNsrxm(gxYyQlrJtcy.getJtcymc());
                    srfjtcyDTO.setSfzjlxDm(gxYyQlrJtcy.getJtcyzjzl());
                    srfjtcyDTO.setSfzjlxMc(gxYyQlrJtcy.getJtcyzjzl());
                    srfjtcyDTO.setSfzjhm(gxYyQlrJtcy.getJtcyzjh());
                    srfjtcyDTO.setDyZjhm(gxYyQlr.getQlrzjh());
                    String mc = this.gxYyZdTypeRepository.getRedisUtilsDictMcByDm("JTGX", gxYyQlrJtcy.getJtgx());
                    srfjtcyDTO.setNsrgx(mc);
                    BeanConvertUtil.nullToEmpty((Object)srfjtcyDTO);
                    list.add(this.gxYyZdDzEvent.convertOurToThird(srfjtcyDTO, "AHSSW"));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List qlrzjhList = qlrList.stream().map(GxYyQlr::getQlrzjh).collect(Collectors.toList());
                list = list.stream().filter(jtcyxxDTO -> !qlrzjhList.contains(jtcyxxDTO.getSfzjhm())).collect(Collectors.toList());
            }
        }
        return list;
    }
}

