/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sw.event;

import cn.gtmap.hlw.core.domain.sw.SwSkbwNoticeEventService;
import cn.gtmap.hlw.core.domain.sw.model.notice.SwSkbwNoticeModel;
import cn.gtmap.hlw.core.domain.sw.model.notice.SwSkbwNoticeResultModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYyProcessLysjRel;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYyProcessLysjRelRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SwSkbwNoticeDomainService {
    private static final Logger log = LoggerFactory.getLogger(SwSkbwNoticeDomainService.class);
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private GxYyProcessLysjRelRepository gxYyProcessLysjRelRepository;
    @Resource
    private Map<String, SwSkbwNoticeEventService> eventServiceMap;

    public SwSkbwNoticeResultModel event(SwSkbwNoticeModel paramsModel) {
        LysjModel lysjList;
        GxYyProcessLysjRel gxYyProcessLysjRel;
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        if (StringUtils.isBlank((CharSequence)paramsModel.getProcessId()) && (gxYyProcessLysjRel = this.gxYyProcessLysjRelRepository.getByLysjdmAndSqlx(paramsModel.getLysjdm(), paramsModel.getSqlx())) != null) {
            paramsModel.setProcessId(gxYyProcessLysjRel.getProcessId());
        }
        if ((lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), "", paramsModel.getAnid(), paramsModel.getSqlx())) == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        SwSkbwNoticeResultModel resultModel = new SwSkbwNoticeResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            try {
                SwSkbwNoticeEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                eventService.doWork(paramsModel, resultModel);
            }
            catch (Exception e) {
                log.error("\u7a0e\u6b3e\u62a5\u6587\u56de\u8c03\u901a\u77e5\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), lydz.getLydzmc() + "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
            }
        }
        return resultModel;
    }
}

