/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sw.event;

import cn.gtmap.hlw.core.domain.sw.SwScddEventService;
import cn.gtmap.hlw.core.domain.sw.model.scdd.SwScddModel;
import cn.gtmap.hlw.core.domain.sw.model.scdd.SwScddResultModel;
import cn.gtmap.hlw.core.enums.JddmEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxZtRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SwScddDomainService {
    private static final Logger log = LoggerFactory.getLogger(SwScddDomainService.class);
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private GxYySqlxJdxxZtRepository sqlxJdxxZtRepository;
    @Autowired
    private Map<String, SwScddEventService> eventServiceMap;

    public SwScddResultModel event(SwScddModel paramsModel) {
        GxYySqxx gxYySqxx = paramsModel.getGxYySqxx();
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), JddmEnum.JDDM_BDJS_5002.getCode(), paramsModel.getAnid(), gxYySqxx.getSqlx());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        SwScddResultModel resultModel = new SwScddResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            try {
                SwScddEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                eventService.doWork(paramsModel, resultModel);
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u8ba2\u5355\u4e8b\u4ef6\u9519\u8bef\uff1a", (Throwable)e);
                this.sqlxJdxxZtRepository.updateFaill(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_5002.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
                throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), e.getMessage());
            }
        }
        return resultModel;
    }
}

