/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sw.event;

import cn.gtmap.hlw.core.domain.sw.SwHsEventService;
import cn.gtmap.hlw.core.domain.sw.model.hs.SwHsParamsModel;
import cn.gtmap.hlw.core.domain.sw.model.hs.SwHsResultModel;
import cn.gtmap.hlw.core.enums.JddmEnum;
import cn.gtmap.hlw.core.enums.dict.SwztEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYyProcessLysjRelRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxZtRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SwHsDomainService {
    private static final Logger log = LoggerFactory.getLogger(SwHsDomainService.class);
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    HlwPzPzxRepository hlwPzPzxRepository;
    @Autowired
    private GxYyProcessLysjRelRepository gxYyProcessLysjRelRepository;
    @Autowired
    private GxYySqxxRepository gxYySqxxRepository;
    @Autowired
    private GxYySqlxJdxxZtRepository sqlxJdxxZtRepository;
    @Autowired
    private Map<String, SwHsEventService> eventServiceMap;

    public SwHsResultModel event(SwHsParamsModel paramsModel) {
        GxYySqxx gxYySqxx = null;
        if (paramsModel.getGxYySqxx() == null) {
            gxYySqxx = this.gxYySqxxRepository.getSqxxZyBySlbh(paramsModel.getSlbh());
            if (gxYySqxx == null) {
                throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u672a\u67e5\u8be2\u5230\u8be5\u7533\u8bf7\u4fe1\u606f");
            }
        } else {
            gxYySqxx = paramsModel.getGxYySqxx();
        }
        if (StringUtils.equals((CharSequence)gxYySqxx.getSwzt(), (CharSequence)SwztEnum.SWZT_YJS.getCode())) {
            return new SwHsResultModel();
        }
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), JddmEnum.JDDM_BDJS_3001.getCode(), paramsModel.getAnid(), gxYySqxx.getSqlx());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        BeanConvertUtil.setProperty((Object)paramsModel, (Object)gxYySqxx, (String)"qydm");
        this.setqhdm(paramsModel, gxYySqxx);
        paramsModel.setGxYySqxx(gxYySqxx);
        SwHsResultModel resultModel = new SwHsResultModel();
        Boolean flag = true;
        try {
            for (GxYyLydz lydz : lysjList.getLydzList()) {
                SwHsEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                if (StringUtils.isNotBlank((CharSequence)resultModel.getFhm()) && StringUtils.equals((CharSequence)ErrorEnum.FAIL.getCode(), (CharSequence)resultModel.getFhm())) {
                    flag = false;
                    break;
                }
                eventService.doWork(paramsModel, resultModel);
                if (paramsModel.getSfzzlydz() == null || !paramsModel.getSfzzlydz().booleanValue()) continue;
                log.info("\u7531\u4e8e\u9886\u57df\u52a8\u4f5c{}\u901a\u77e5\uff0c\u540e\u7eed\u52a8\u4f5c\u5df2\u7ec8\u6b62\u6267\u884c", (Object)lydz.getLydzsxl());
                break;
            }
            if (flag.booleanValue()) {
                this.sqlxJdxxZtRepository.updateToSucess(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_3001.getCode());
            }
        }
        catch (BizException e) {
            log.error("\u7a0e\u52a1\u6838\u7a0e\u4e8b\u4ef6\u9519\u8bef\uff1a", (Throwable)e);
            this.sqlxJdxxZtRepository.updateFaill(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_3001.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
            throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
        return resultModel;
    }

    private void setqhdm(Object paramsModel, GxYySqxx gxYySqxx) {
        if (StringUtils.isNotBlank((CharSequence)gxYySqxx.getQydm())) {
            try {
                Method setQydmMethod = paramsModel.getClass().getMethod("setQydm", String.class);
                if (setQydmMethod != null) {
                    setQydmMethod.invoke(paramsModel, gxYySqxx.getQydm());
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new BizException(ErrorEnum.INTERNAL_SERVER_ERROR.getCode(), "\u53cd\u5c04\u9519\u8bef:" + e.getMessage());
            }
        }
    }
}

