/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sw.event;

import cn.gtmap.hlw.core.domain.sw.SwDzfpEventService;
import cn.gtmap.hlw.core.domain.sw.model.dzfp.SwDzfpParamsModel;
import cn.gtmap.hlw.core.domain.sw.model.dzfp.SwDzfpResultModel;
import cn.gtmap.hlw.core.enums.JddmEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxLysjRelRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxZtRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SwDzfpDomainService {
    private static final Logger log = LoggerFactory.getLogger(SwDzfpDomainService.class);
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private GxYySqlxJdxxLysjRelRepository sqlxJdxxLysjRelRepository;
    @Autowired
    private GxYySqlxJdxxZtRepository sqlxJdxxZtRepository;
    @Autowired
    private Map<String, SwDzfpEventService> eventServiceMap;

    public SwDzfpResultModel event(SwDzfpParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        GxYySqxx gxYySqxx = paramsModel.getGxYySqxx();
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), JddmEnum.JDDM_BDJS_5006.getCode(), paramsModel.getAnid(), gxYySqxx.getSqlx());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        SwDzfpResultModel resultModel = new SwDzfpResultModel();
        try {
            for (GxYyLydz lydz : lysjList.getLydzList()) {
                SwDzfpEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                eventService.doWork(paramsModel, resultModel);
            }
            this.sqlxJdxxZtRepository.updateToSucess(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_5006.getCode());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7535\u5b50\u53d1\u7968\u4e8b\u4ef6\u9519\u8bef\uff1a", (Throwable)e);
            this.sqlxJdxxZtRepository.updateFaill(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_5006.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
            throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), e.getMessage());
        }
        return resultModel;
    }
}

