/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sw.event;

import cn.gtmap.hlw.core.domain.sw.SwCxTkztEventService;
import cn.gtmap.hlw.core.domain.sw.model.scdd.SwTkModel;
import cn.gtmap.hlw.core.domain.sw.model.scdd.SwTkResultModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SwCxTkztDomainService {
    private static final Logger log = LoggerFactory.getLogger(SwCxTkztDomainService.class);
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, SwCxTkztEventService> eventServiceMap;

    public SwTkResultModel event(SwTkModel paramsModel) {
        GxYySqxx gxYySqxx = paramsModel.getGxYySqxx();
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), "", paramsModel.getAnid(), gxYySqxx.getSqlx());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        SwTkResultModel resultModel = new SwTkResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            try {
                SwCxTkztEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                eventService.doWork(paramsModel, resultModel);
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u8ba2\u5355\u4e8b\u4ef6\u9519\u8bef\uff1a", (Throwable)e);
                throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), e.getMessage());
            }
        }
        return resultModel;
    }
}

