/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.stgx;

import cn.gtmap.hlw.core.domain.stgx.StgxthirdEventService;
import cn.gtmap.hlw.core.domain.stgx.model.GxxxThirdParamModel;
import cn.gtmap.hlw.core.domain.stgx.model.GxxxThirdResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StgxThirdDomainService {
    private static final Logger log = LoggerFactory.getLogger(StgxThirdDomainService.class);
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, StgxthirdEventService> stgxthirdEventServiceMap;

    public GxxxThirdResultModel event(GxxxThirdParamModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        GxxxThirdResultModel resultModel = new GxxxThirdResultModel();
        log.info("StgxThirdDomainService,lysjList:{}", (Object)JSON.toJSONString((Object)lysjList));
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            StgxthirdEventService eventService = this.stgxthirdEventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }
}

