/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.tz;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.domain.sqxx.MySqxxTzPageEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.tz.SqxxTzParamsModel;
import cn.gtmap.hlw.core.domain.sqxx.model.tz.SqxxTzResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MySqxxTzDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, MySqxxTzPageEventService> eventServiceMap;

    PageInfo<List<SqxxTzResultModel>> page(SqxxTzParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        PageInfo resultModelList = new PageInfo();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            MySqxxTzPageEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModelList);
        }
        return resultModelList;
    }
}

