/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.sqxx.check;

import cn.gtmap.hlw.core.domain.sqxx.SqxxSaveEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.SqxxSaveModel;
import cn.gtmap.hlw.core.domain.sqxx.model.fwtc.JtcyFwtcQueryParamsModel;
import cn.gtmap.hlw.core.domain.sqxx.model.fwtc.JtcyFwtcQueryResultModel;
import cn.gtmap.hlw.core.dto.third.mz.fwtc.JtcyFwtcJtcyxxQueryParamsDTO;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.enums.qlr.QlrTypeEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.domain.sqxx.event.SqxxFwtcDomainService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SaveBeforeCheckFwtcEvent
implements SqxxSaveEventService {
    private static final Logger log = LoggerFactory.getLogger(SaveBeforeCheckFwtcEvent.class);
    @Resource
    private SqxxFwtcDomainService sqxxFwtcDomainService;

    public void doWork(SqxxSaveModel sqxxSaveModel) {
        List qlrList = sqxxSaveModel.getQlrList();
        if (CollectionUtils.isEmpty(qlrList = qlrList.stream().filter(qlr -> StringUtils.equals((CharSequence)QlrTypeEnum.QLRLX_QLR.getCode(), (CharSequence)qlr.getQlrlx())).collect(Collectors.toList()))) {
            return;
        }
        for (GxYyQlr qlr2 : qlrList) {
            JtcyFwtcQueryParamsModel paramsModel = (JtcyFwtcQueryParamsModel)BeanConvertUtil.getBeanByJsonObj((Object)qlr2, JtcyFwtcQueryParamsModel.class);
            paramsModel.setQydm(sqxxSaveModel.getSqxx().getQydm());
            paramsModel.setSqid(sqxxSaveModel.getSqxx().getSqid());
            paramsModel.setJtcyList(BeanConvertUtil.getBeanListByJsonArray((Object)qlr2.getJtcyList(), JtcyFwtcJtcyxxQueryParamsDTO.class));
            paramsModel.setLysjdm("lysjdm.jtcy.fwtccheck");
            JtcyFwtcQueryResultModel jtcyFwtcQueryResultModel = this.sqxxFwtcDomainService.event(paramsModel);
            log.info("qlr\u623f\u5c4b\u5957\u6b21\uff1a{},\u67e5\u8be2\u623f\u5c4b\u5957\u6b21\uff1a{}", (Object)qlr2.getFwtc(), (Object)jtcyFwtcQueryResultModel.getFwtc());
            if (!StringUtils.isNotBlank((CharSequence)qlr2.getFwtc()) || !StringUtils.isNotBlank((CharSequence)jtcyFwtcQueryResultModel.getFwtc()) || qlr2.getFwtc().compareTo(jtcyFwtcQueryResultModel.getFwtc()) >= 0) continue;
            throw new BizException(ErrorEnum.CHECK_FAIL.getCode(), qlr2.getQlrmc() + ":\u5bb6\u5ead\u6210\u5458\u623f\u5c4b\u5957\u6b21\u6838\u9a8c\u4e0d\u901a\u8fc7\uff01");
        }
    }
}

