/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.sqxx.audit;

import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.hlw.core.base.UserInfo;
import cn.gtmap.hlw.core.domain.sqxx.SqxxAuditEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.audit.SqxxAuditParamsModel;
import cn.gtmap.hlw.core.enums.JddmEnum;
import cn.gtmap.hlw.core.enums.dict.SlztEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.model.GxYyRole;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYySqxxSpxx;
import cn.gtmap.hlw.core.repository.GxYyRoleRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxZtRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxSpxxRepository;
import cn.gtmap.hlw.core.util.session.SessionUtil;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.gtmap.hlw.domain.login.enums.LoginStatusEnum;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class UpdateSlztAuditEvent
implements SqxxAuditEventService {
    @Resource
    private GxYyRoleRepository gxYyRoleRepository;
    @Resource
    private GxYySqxxRepository gxYySqxxRepository;
    @Resource
    private GxYySqxxSpxxRepository gxYySqxxSpxxRepository;
    @Resource
    private GxYySqlxJdxxZtRepository gxYySqlxJdxxZtRepository;

    public void doWork(SqxxAuditParamsModel sqxxAuditModel) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sqxxAuditModel.getSlbh(), sqxxAuditModel.getSlzt()})) {
            throw new BizException((IError)ErrorEnum.PARAM_NULL);
        }
        UserInfo user = SessionUtil.getUser();
        if (user == null) {
            throw new BizException(LoginStatusEnum.NO_USER.getCode(), LoginStatusEnum.NO_USER.getMsg());
        }
        GxYyRole role = this.gxYyRoleRepository.get(user.getRoleId());
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)role.getIsAdmin())) {
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u89d2\u8272\u5c5e\u4e8e\u5206\u7ea7\u7ba1\u7406\u5458\u624d\u80fd\u6709\u6743\u9650\u64cd\u4f5c");
        }
        if (!StringUtils.equalsAny((CharSequence)sqxxAuditModel.getSlzt(), (CharSequence[])new CharSequence[]{SlztEnum.SLZT_YSTG.getCode(), SlztEnum.SLZT_YSWTG.getCode(), SlztEnum.SLZT_BJ.getCode()})) {
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u53d7\u7406\u72b6\u6001\u4e0d\u5408\u6cd5");
        }
        List sqxxList = this.gxYySqxxRepository.list(sqxxAuditModel.getSlbh());
        if (CollectionUtils.isEmpty((Collection)sqxxList)) {
            throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u672a\u67e5\u8be2\u5230\u8be5\u7533\u8bf7\u4fe1\u606f");
        }
        String judgeSlzt = CommonUtil.formatEmptyValue((Object)((GxYySqxx)sqxxList.get(0)).getSlzt());
        if (!StringUtils.equalsAny((CharSequence)judgeSlzt, (CharSequence[])new CharSequence[]{SlztEnum.SLZT_HQZ.getCode(), SlztEnum.SLZT_SHZ.getCode(), SlztEnum.SLZT_HQTG.getCode()})) {
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u7533\u8bf7\u4fe1\u606f\u5f53\u524d\u53d7\u7406\u72b6\u6001\u4e0d\u5141\u8bb8\u9884\u5ba1");
        }
        if (StringUtils.equals((CharSequence)sqxxAuditModel.getSlzt(), (CharSequence)SlztEnum.SLZT_YSTG.getCode())) {
            this.gxYySqlxJdxxZtRepository.updateToSucess(sqxxAuditModel.getSlbh(), JddmEnum.JDDM_BDJS_4001.getCode());
        } else if (StringUtils.equals((CharSequence)sqxxAuditModel.getSlzt(), (CharSequence)SlztEnum.SLZT_YSWTG.getCode())) {
            this.gxYySqlxJdxxZtRepository.updateFaill(sqxxAuditModel.getSlbh(), JddmEnum.JDDM_BDJS_4001.getCode(), sqxxAuditModel.getSlxx());
        }
        for (GxYySqxx sqxx : sqxxList) {
            GxYySqxx newSqxx = new GxYySqxx();
            sqxx.setSlzt(Integer.valueOf(Integer.parseInt(sqxxAuditModel.getSlzt())));
            sqxx.setEditUser(user.getUserGuid());
            sqxx.setSlxx(sqxxAuditModel.getSlxx());
            newSqxx.setSlxx(sqxx.getSlxx());
            newSqxx.setSlzt(sqxx.getSlzt());
            newSqxx.setEditUser(sqxx.getEditUser());
            newSqxx.setEditDate(new Date());
            newSqxx.setYytgsj(new Date());
            newSqxx.setSqid(sqxx.getSqid());
            this.gxYySqxxRepository.update(newSqxx);
            GxYySqxxSpxx gxYySqxxSpxx = new GxYySqxxSpxx();
            gxYySqxxSpxx.setSlbh(sqxxAuditModel.getSlbh());
            gxYySqxxSpxx.setSpid(StringUtil.hex32());
            gxYySqxxSpxx.setSqid(sqxx.getSqid());
            gxYySqxxSpxx.setSpry(user.getUserGuid());
            gxYySqxxSpxx.setSpsj(new Date());
            gxYySqxxSpxx.setSpxx(sqxx.getSlxx());
            gxYySqxxSpxx.setSpzt(sqxx.getSlzt().toString());
            gxYySqxxSpxx.setSpry(user.getUserGuid());
            gxYySqxxSpxx.setSprymc(user.getRealName());
            this.gxYySqxxSpxxRepository.saveOrUpdate(gxYySqxxSpxx);
        }
    }
}

