/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.sqxx.audit;

import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.hlw.core.base.UserInfo;
import cn.gtmap.hlw.core.domain.sqxx.SqxxAuditEventService;
import cn.gtmap.hlw.core.domain.sqxx.SqxxCommitEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.audit.SqxxAuditParamsModel;
import cn.gtmap.hlw.core.domain.sqxx.model.commit.SqxxCommitParamsModel;
import cn.gtmap.hlw.core.domain.sqxx.model.commit.SqxxCommitResultModel;
import cn.gtmap.hlw.core.enums.dict.RoleEnum;
import cn.gtmap.hlw.core.enums.dict.SfrzEnum;
import cn.gtmap.hlw.core.enums.dict.SlztEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.model.GxYyOrg;
import cn.gtmap.hlw.core.model.GxYyOrgDz;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYySqxxHq;
import cn.gtmap.hlw.core.model.GxYyZdSqlx;
import cn.gtmap.hlw.core.repository.GxYyOrgDzRepository;
import cn.gtmap.hlw.core.repository.GxYyOrgRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxHqRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdSqlxRepository;
import cn.gtmap.hlw.core.util.session.SessionUtil;
import cn.gtmap.hlw.domain.login.enums.LoginStatusEnum;
import cn.gtmap.hlw.domain.sqxx.enums.HqfsEnum;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HySuccesEvent
implements SqxxAuditEventService {
    private static final Logger log = LoggerFactory.getLogger(HySuccesEvent.class);
    @Resource
    private GxYySqxxHqRepository gxYySqxxHqRepository;
    @Resource
    private GxYySqxxRepository gxYySqxxRepository;
    @Autowired
    private GxYyQlrRepository gxYyQlrRepository;
    @Autowired
    private Map<String, SqxxCommitEventService> eventServiceMap;
    @Autowired
    private GxYyOrgDzRepository gxYyOrgDzRepository;
    @Autowired
    private GxYyOrgRepository gxYyOrgRepository;
    @Resource
    private GxYyZdSqlxRepository gxYyZdSqlxRepository;

    public void doWork(SqxxAuditParamsModel sqxxAuditModel) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sqxxAuditModel.getSlbh(), sqxxAuditModel.getSlzt()})) {
            throw new BizException((IError)ErrorEnum.PARAM_NULL);
        }
        UserInfo user = SessionUtil.getUser();
        if (user == null) {
            throw new BizException(LoginStatusEnum.NO_USER.getCode(), LoginStatusEnum.NO_USER.getMsg());
        }
        List sqxxList = this.gxYySqxxRepository.list(sqxxAuditModel.getSlbh());
        if (CollectionUtils.isEmpty((Collection)sqxxList)) {
            throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u672a\u67e5\u8be2\u5230\u8be5\u7533\u8bf7\u4fe1\u606f");
        }
        String judgeSlzt = CommonUtil.formatEmptyValue((Object)((GxYySqxx)sqxxList.get(0)).getSlzt());
        String sqlxdm = CommonUtil.formatEmptyValue((Object)((GxYySqxx)sqxxList.get(0)).getSqlx());
        if (!StringUtils.equalsAny((CharSequence)judgeSlzt, (CharSequence[])new CharSequence[]{SlztEnum.SLZT_HQZ.getCode(), SlztEnum.SLZT_YSWTG.getCode()})) {
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u7533\u8bf7\u4fe1\u606f\u5f53\u524d\u53d7\u7406\u72b6\u6001\u4e0d\u5141\u8bb8\u6838\u9a8c");
        }
        List qlrList = this.gxYyQlrRepository.getBySlbh(sqxxAuditModel.getSlbh());
        int count = 0;
        for (GxYyQlr qlr : qlrList) {
            boolean sfbr = false;
            if (StringUtils.equals((CharSequence)user.getRoleId(), (CharSequence)RoleEnum.BDGL_ROLE_GR.getCode())) {
                if (qlr.getQlrzjh().equals(user.getUserZjid())) {
                    sfbr = true;
                }
            } else {
                List gxYyOrgList;
                if (qlr.getQlrzjh().equals(user.getOrgTyxydm()) && qlr.getQlrmc().equals(user.getOrgName())) {
                    sfbr = true;
                }
                if (!sfbr && StringUtils.isNotBlank((CharSequence)user.getOrgId()) && StringUtils.isNotBlank((CharSequence)qlr.getQlrmc()) && CollectionUtils.isNotEmpty((Collection)(gxYyOrgList = this.gxYyOrgRepository.getOrgAndChilds(user.getOrgId())))) {
                    for (GxYyOrg org : gxYyOrgList) {
                        GxYyOrgDz gxYyOrgDz = this.gxYyOrgDzRepository.selectOrganizeDzByOrgIdAndMc(org.getOrgId(), qlr.getQlrmc());
                        if (gxYyOrgDz == null) continue;
                        sfbr = true;
                    }
                }
            }
            log.info("\u4fee\u6539\u4f1a\u7b7e\u8ba4\u8bc1\u72b6\u6001sfbr:{}", (Object)JSONObject.toJSONString((Object)sfbr));
            if (!sfbr) continue;
            GxYySqxxHq sqxxHq = new GxYySqxxHq();
            sqxxHq.setSfrz(SfrzEnum.SFRZ_RZTG.getCode());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qlr.getFddbrhfzr(), qlr.getFddbrhfzrzjh(), qlr.getFddbrhfzrid()})) {
                sqxxHq.setFddbrhfzrid(qlr.getFddbrhfzrid());
            }
            sqxxHq.setQlrid(qlr.getQlrid());
            sqxxHq.setSlbh(sqxxAuditModel.getSlbh());
            log.info("\u4fee\u6539\u4f1a\u7b7e\u8ba4\u8bc1\u72b6\u6001:{}", (Object)JSONObject.toJSONString((Object)sqxxHq));
            this.gxYySqxxHqRepository.updateSqxxHqSfrz(sqxxHq);
            ++count;
            this.updateSfrzByHqfs(sqxxAuditModel, sqlxdm);
        }
        if (count > 0) {
            SqxxCommitParamsModel paramsDTO = new SqxxCommitParamsModel();
            SqxxCommitResultModel resultModel = new SqxxCommitResultModel();
            paramsDTO.setSlbh(sqxxAuditModel.getSlbh());
            paramsDTO.setGxYySqxxList(sqxxList);
            SqxxCommitEventService eventService = this.eventServiceMap.get("sqxxCommitUpdateSlztEvent");
            eventService.doWork(paramsDTO, resultModel);
        }
    }

    private void updateSfrzByHqfs(SqxxAuditParamsModel sqxxAuditModel, String sqlxdm) {
        List gxYySqxxHqList;
        GxYyZdSqlx gxYyZdSqlx = this.gxYyZdSqlxRepository.getSqlxBySqlxdm(sqlxdm);
        if (gxYyZdSqlx == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)HqfsEnum.HQFS_SFHQ.getCode(), (CharSequence)gxYyZdSqlx.getHqfs()) && CollectionUtils.isNotEmpty((Collection)(gxYySqxxHqList = this.gxYySqxxHqRepository.getBySlbh(sqxxAuditModel.getSlbh())))) {
            int rztgNum = 0;
            GxYySqxxHq dyqrSqxxHq = null;
            for (GxYySqxxHq gxYySqxxHq : gxYySqxxHqList) {
                if (SfrzEnum.SFRZ_RZTG.getCode().equals(gxYySqxxHq.getSfrz())) {
                    ++rztgNum;
                }
                if (!SfrzEnum.DRZ_GR.getCode().equals(gxYySqxxHq.getSfrz())) continue;
                dyqrSqxxHq = gxYySqxxHq;
            }
            if (rztgNum == gxYySqxxHqList.size() - 1 && dyqrSqxxHq != null) {
                dyqrSqxxHq.setSfrz(SfrzEnum.SFRZ_WRZ.getCode());
                this.gxYySqxxHqRepository.update(dyqrSqxxHq);
            }
        }
    }
}

