/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.sqxx;

import cn.gtmap.estateplat.register.common.util.PublicUtil;
import cn.gtmap.hlw.core.domain.sqxx.SqxxSaveEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.SqxxSaveModel;
import cn.gtmap.hlw.core.enums.dict.GyfsEnum;
import cn.gtmap.hlw.core.enums.dict.TkGyfsEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYySqxxWxbl;
import cn.gtmap.hlw.core.model.GxYyZdSqxxTk;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxWxblRepository;
import cn.gtmap.hlw.core.repository.GxYyZdSqxxTkRepository;
import cn.gtmap.hlw.core.repository.GxYyZdTypeRepository;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SqxxWxblSaveEvent
implements SqxxSaveEventService {
    @Autowired
    GxYyZdSqxxTkRepository gxYyZdSqxxTkRepository;
    @Autowired
    GxYySqxxRepository gxYySqxxRepository;
    @Autowired
    GxYySqxxWxblRepository gxYySqxxWxblRepository;
    @Autowired
    GxYyQlrRepository gxYyQlrRepository;
    @Autowired
    GxYyZdTypeRepository gxYyZdTypeRepository;

    public void doWork(SqxxSaveModel sqxxSaveModel) {
        GxYySqxx gxYySqxx = sqxxSaveModel.getSqxx();
        if (gxYySqxx == null) {
            throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u672a\u67e5\u8be2\u5230\u7533\u8bf7\u4fe1\u606f");
        }
        List gxYyQlrList = this.gxYyQlrRepository.list(gxYySqxx.getSqid());
        if (CollectionUtils.isEmpty((Collection)gxYyQlrList)) {
            return;
        }
        List sqxxTkList = this.gxYyZdSqxxTkRepository.getBySqlx(gxYySqxx.getSqdjlx());
        List wxblList = this.gxYySqxxWxblRepository.getBySlbh(sqxxSaveModel.getSlbh());
        if (CollectionUtils.isEmpty((Collection)wxblList)) {
            return;
        }
        for (GxYySqxxWxbl gxYySqxxWxbl : wxblList) {
            JSONObject map = new JSONObject();
            String gyfs = "";
            String gyfsmc = "";
            StringBuilder afgyText = new StringBuilder();
            for (GxYyQlr gxYyQlr : gxYyQlrList) {
                if (!StringUtils.equals((CharSequence)gxYySqxxWxbl.getQlrlx(), (CharSequence)gxYyQlr.getQlrlx())) continue;
                gyfsmc = this.gxYyZdTypeRepository.getRedisUtilsDictMcByDm("GYFS", gxYyQlr.getGyfs());
                gyfs = gxYyQlr.getGyfs();
                afgyText.append(gxYyQlr.getQlrmc()).append("\u5360").append(gxYyQlr.getQlbl()).append("% ");
            }
            this.dealWithTk(map, gyfs, gyfsmc, afgyText, sqxxTkList, gxYySqxxWxbl);
            gxYySqxxWxbl.setDmDa(map.toJSONString());
        }
        this.gxYySqxxWxblRepository.saveOrUpdateBatch(wxblList);
    }

    private void dealWithTm(GxYyZdSqxxTk gxYyZdSqxxTk, JSONObject json, String gyfs) {
        Map xxMap = (Map)PublicUtil.getBeanByJsonObj((Object)gxYyZdSqxxTk.getXx(), HashMap.class);
        for (Map.Entry entry : xxMap.entrySet()) {
            if (!StringUtils.equals((CharSequence)gyfs, (CharSequence)((CharSequence)entry.getValue()))) continue;
            json.put(gxYyZdSqxxTk.getDm(), entry.getKey());
        }
    }

    private void dealWithTk(JSONObject map, String gyfs, String gyfsmc, StringBuilder afgyText, List<GxYyZdSqxxTk> sqxxTkList, GxYySqxxWxbl gxYySqxxWxbl) {
        if (CollectionUtils.isEmpty(sqxxTkList)) {
            return;
        }
        for (GxYyZdSqxxTk gxYyZdSqxxTk : sqxxTkList) {
            if (!StringUtils.equals((CharSequence)gxYySqxxWxbl.getQlrlx(), (CharSequence)gxYyZdSqxxTk.getQlrlx())) continue;
            if (StringUtils.equals((CharSequence)TkGyfsEnum.TM_1.getCode(), (CharSequence)gxYyZdSqxxTk.getGyfs())) {
                if (StringUtils.equalsAny((CharSequence)gyfs, (CharSequence[])new CharSequence[]{GyfsEnum.AFGY.getCode(), GyfsEnum.GTGY.getCode()})) {
                    this.dealWithTm(gxYyZdSqxxTk, map, "\u5171\u6709");
                    continue;
                }
                this.dealWithTm(gxYyZdSqxxTk, map, gyfsmc);
                continue;
            }
            if (StringUtils.equals((CharSequence)TkGyfsEnum.TM_2.getCode(), (CharSequence)gxYyZdSqxxTk.getGyfs())) {
                if (StringUtils.equalsAny((CharSequence)gyfs, (CharSequence[])new CharSequence[]{GyfsEnum.AFGY.getCode(), GyfsEnum.GTGY.getCode()})) {
                    this.dealWithTm(gxYyZdSqxxTk, map, gyfsmc);
                    continue;
                }
                map.put(gxYyZdSqxxTk.getDm(), (Object)"");
                continue;
            }
            if (StringUtils.equals((CharSequence)TkGyfsEnum.TM_3.getCode(), (CharSequence)gxYyZdSqxxTk.getGyfs())) {
                if (StringUtils.equals((CharSequence)gyfs, (CharSequence)GyfsEnum.AFGY.getCode())) {
                    map.put(gxYyZdSqxxTk.getDm(), (Object)afgyText.toString());
                    continue;
                }
                map.put(gxYyZdSqxxTk.getDm(), (Object)"");
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)gxYyZdSqxxTk.getGyfs()) || map.containsKey((Object)gxYyZdSqxxTk.getDm())) continue;
            map.put(gxYyZdSqxxTk.getDm(), (Object)gxYyZdSqxxTk.getDa());
        }
    }
}

