/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.sqxx;

import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.hlw.core.domain.sqxx.SqxxSaveEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.SqxxSaveModel;
import cn.gtmap.hlw.core.enums.SjlyEnum;
import cn.gtmap.hlw.core.enums.dict.JfztEnum;
import cn.gtmap.hlw.core.enums.dict.SwztEnum;
import cn.gtmap.hlw.core.enums.qlr.CzfsEnum;
import cn.gtmap.hlw.core.enums.qlr.QlrTypeEnum;
import cn.gtmap.hlw.core.enums.status.Status2Enum;
import cn.gtmap.hlw.core.enums.status.StatusEnum;
import cn.gtmap.hlw.core.model.GxYyOrg;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYySqxxHtxx;
import cn.gtmap.hlw.core.model.GxYySqxxKz;
import cn.gtmap.hlw.core.model.GxYyZdSqlx;
import cn.gtmap.hlw.core.repository.GxYyOrgRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxKzRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdSqlxRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.gtmap.hlw.domain.dict.event.GxYyZdTypeEvent;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCertificateEnum;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyStatusEnum;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SqxxSaveEvent
implements SqxxSaveEventService {
    private static final Logger log = LoggerFactory.getLogger(SqxxSaveEvent.class);
    private static final Logger logger = LoggerFactory.getLogger(SqxxSaveEvent.class);
    @Autowired
    GxYyZdTypeEvent gxYyZdTypeEvent;
    @Autowired
    RedisRepository redisRepository;
    @Autowired
    GxYySqxxRepository gxYySqxxRepository;
    @Resource
    private GxYySqxxKzRepository gxYySqxxKzRepository;
    @Autowired
    GxYyZdSqlxRepository gxYyZdSqlxRepository;
    @Autowired
    private GxYyOrgRepository gxYyOrgRepository;

    public void doWork(SqxxSaveModel sqxxSaveModel) {
        GxYySqxx sqxx = this.setSqxxInfo(sqxxSaveModel.getSqxx());
        List qlrList = sqxxSaveModel.getQlrList();
        HashSet<String> fczhSet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)sqxx.getFczhList())) {
            fczhSet.addAll(Arrays.asList(sqxx.getFczhList().split(",")));
        } else if (StringUtils.isNotBlank((CharSequence)sqxx.getFczh())) {
            List<String> sqxxCqzhList = Arrays.asList(sqxx.getFczh().split(","));
            fczhSet.addAll(sqxxCqzhList);
        }
        StringBuilder qlrmc = new StringBuilder();
        StringBuilder qlrzjh = new StringBuilder();
        StringBuilder ywrmc = new StringBuilder();
        StringBuilder ywrzjh = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)qlrList)) {
            for (GxYyQlr qlr : qlrList) {
                if (StringUtils.isBlank((CharSequence)sqxx.getSffbcz())) {
                    if (StringUtils.equals((CharSequence)CommonUtil.formatEmptyValue((Object)qlr.getCzfs()), (CharSequence)CzfsEnum.CZFS_GTCZ.getCode())) {
                        sqxx.setSffbcz(Status2Enum.NO.getCode());
                    } else if (StringUtils.equals((CharSequence)CommonUtil.formatEmptyValue((Object)qlr.getCzfs()), (CharSequence)CzfsEnum.CZFS_FBCZ.getCode())) {
                        sqxx.setSffbcz(Status2Enum.YES.getCode());
                    }
                }
                if (StringUtils.equals((CharSequence)qlr.getQlrlx(), (CharSequence)QlrTypeEnum.QLRLX_QLR.getCode())) {
                    qlrmc.append(",").append(qlr.getQlrmc());
                    qlrzjh.append(",").append(qlr.getQlrzjh());
                }
                if (StringUtils.equals((CharSequence)qlr.getQlrlx(), (CharSequence)QlrTypeEnum.QLRLX_YWR.getCode())) {
                    ywrmc.append(",").append(qlr.getQlrmc());
                    ywrzjh.append(",").append(qlr.getQlrzjh());
                }
                if (!StringUtils.isNotBlank((CharSequence)qlr.getFczh())) continue;
                List<String> qlrCqzhList = Arrays.asList(qlr.getFczh().split(","));
                fczhSet.addAll(qlrCqzhList);
            }
        }
        sqxx.setFczhList(StringUtils.join(new ArrayList(fczhSet), (String)","));
        sqxx.setQlrmc(qlrmc.toString().replaceFirst(",", ""));
        sqxx.setQlrzjh(qlrzjh.toString().replaceFirst(",", ""));
        sqxx.setYwrmc(ywrmc.toString().replaceFirst(",", ""));
        sqxx.setYwrzjh(ywrzjh.toString().replaceFirst(",", ""));
        Object object = BeanConvertUtil.convertMap((Map)BeanConvertUtil.convertBean((Object)sqxx), GxYySqxx.class);
        sqxx = (GxYySqxx)BeanConvertUtil.getBeanByJsonObj((Object)object, GxYySqxx.class);
        GxYySqxxHtxx gxYySqxxHtxx = sqxxSaveModel.getHtxx();
        if (gxYySqxxHtxx != null) {
            if (gxYySqxxHtxx.getJyjg() != null && gxYySqxxHtxx.getJyjg() > 0.0) {
                sqxx.setJyjg(gxYySqxxHtxx.getJyjg());
            }
            if (StringUtils.isNotBlank((CharSequence)gxYySqxxHtxx.getFkfs())) {
                sqxx.setFkfs(gxYySqxxHtxx.getFkfs());
            }
            if (StringUtils.isBlank((CharSequence)sqxx.getMmhth())) {
                sqxx.setMmhth(gxYySqxxHtxx.getWthth());
            }
        }
        if (sqxxSaveModel.getZjxx() != null && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sqxx.getSqid(), sqxx.getSlbh(), sqxx.getCreateUserid(), sqxxSaveModel.getZjxx().getZjmc()})) {
            sqxx.setSfczzjxx(StatusEnum.TRUE.getCode());
        }
        if (sqxxSaveModel.getDyxx() != null) {
            sqxx.setBdbzzqse(sqxxSaveModel.getDyxx().getDyje());
        }
        if (sqxx.getCreateDate() == null) {
            sqxx.setCreateDate(new Date());
        }
        this.gxYySqxxRepository.saveOrUpdate(sqxx);
        this.saveKzxx(sqxxSaveModel);
    }

    private void saveKzxx(SqxxSaveModel sqxxSaveModel) {
        GxYySqxxKz sqxxKz = (GxYySqxxKz)BeanConvertUtil.getBeanByJsonObj((Object)sqxxSaveModel.getSqxx(), GxYySqxxKz.class);
        if (sqxxKz != null) {
            if (StringUtils.isNotBlank((CharSequence)sqxxKz.getDjsy())) {
                sqxxKz.setDjsy(sqxxKz.getDjsy().replace(",", "/"));
            }
            sqxxKz.setSfxsjs(Status2Enum.YES.getCode());
            sqxxKz.setSjly(SjlyEnum.SYLY_HLW.getDm());
            String swzt = sqxxSaveModel.getSqxx().getSwzt();
            if (StringUtils.equals((CharSequence)SwztEnum.SWZT_YJS.getCode(), (CharSequence)swzt)) {
                sqxxKz.setSfxsjs(Status2Enum.NO.getCode());
            }
            this.gxYySqxxKzRepository.saveOrUpdate(sqxxKz);
        }
    }

    public GxYySqxx setSqxxInfo(GxYySqxx sqxx) {
        if (StringUtils.isNotBlank((CharSequence)(sqxx = this.gxYyZdTypeEvent.convertDict(sqxx)).getSffbcz()) && StringUtil.isChinese((String)sqxx.getSffbcz())) {
            sqxx.setSffbcz(Status2Enum.NO.getCode());
            if (StringUtils.equals((CharSequence)sqxx.getSffbcz(), (CharSequence)StatusEnum.TRUE.getMsg())) {
                sqxx.setSffbcz(Status2Enum.YES.getCode());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sqxx.getSszsbs()) && StringUtil.isChinese((String)sqxx.getSszsbs())) {
            sqxx.setSszsbs(ApplyCertificateEnum.SOLE_EDITION.getCode());
            if (StringUtils.equals((CharSequence)sqxx.getSszsbs(), (CharSequence)ApplyCertificateEnum.INTEGRATION_EDITION.getMsg())) {
                sqxx.setSszsbs(ApplyCertificateEnum.INTEGRATION_EDITION.getCode());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sqxx.getSfyj())) {
            sqxx.setSfyj(StatusEnum.FALSE.getCode());
            if (StringUtils.equals((CharSequence)sqxx.getSfyj(), (CharSequence)StatusEnum.TRUE.getMsg()) || StringUtils.equals((CharSequence)sqxx.getSfyj(), (CharSequence)StatusEnum.TRUE.getCode())) {
                sqxx.setSfyj(StatusEnum.TRUE.getCode());
            }
        }
        if (sqxx.getSlzt() == null) {
            sqxx.setSlzt(ApplyStatusEnum.SLZT_WSH.getCode());
        }
        sqxx.setDczt(Integer.valueOf(Status2Enum.NO.getCode()));
        sqxx.setYzzt(Integer.valueOf(Status2Enum.NO.getCode()));
        if (StringUtils.isBlank((CharSequence)sqxx.getMjdw())) {
            sqxx.setMjdw("1");
        }
        if (StringUtils.isBlank((CharSequence)sqxx.getSszsbs())) {
            sqxx.setSszsbs(ApplyCertificateEnum.SOLE_EDITION.getCode());
        }
        if (StringUtils.isBlank((CharSequence)sqxx.getSffbcz())) {
            String sffbcz = StringUtil.toString((Object)this.redisRepository.get("sqxx.sffbcz"));
            if (StringUtils.isBlank((CharSequence)sffbcz)) {
                sffbcz = Status2Enum.NO.getCode();
            }
            sqxx.setSffbcz(sffbcz);
        }
        sqxx.setSfczzjxx(StatusEnum.FALSE.getCode());
        GxYyZdSqlx zdSqlx = this.gxYyZdSqlxRepository.getSqlxBySqlxdm(sqxx.getSqdjlx());
        if (StringUtils.isNotBlank((CharSequence)sqxx.getCreateOrgId())) {
            GxYyOrg gxYyOrg = this.gxYyOrgRepository.get(sqxx.getCreateOrgId());
            log.info("initSqxx.gxYyOrg:" + JSONObject.toJSONString((Object)gxYyOrg));
            if (gxYyOrg != null && StringUtils.equals((CharSequence)gxYyOrg.getSfgz(), (CharSequence)Status2Enum.YES.getCode())) {
                sqxx.setJfzt(JfztEnum.JFZT_YGZ.getCode());
            }
        }
        if (StringUtils.isBlank((CharSequence)sqxx.getJfzt())) {
            if (StringUtils.equals((CharSequence)zdSqlx.getSfjf(), (CharSequence)Status2Enum.YES.getCode())) {
                sqxx.setJfzt(JfztEnum.JFZT_WJF.getCode());
            } else {
                sqxx.setJfzt(JfztEnum.JFZT_WXJF.getCode());
            }
        }
        if (StringUtils.isBlank((CharSequence)sqxx.getSwzt())) {
            if (StringUtils.equals((CharSequence)zdSqlx.getSfxyns(), (CharSequence)Status2Enum.YES.getCode())) {
                sqxx.setSwzt(SwztEnum.SWZT_WHS.getCode());
            } else {
                sqxx.setSwzt(SwztEnum.SWZT_WXNS.getCode());
            }
        }
        return sqxx;
    }
}

