/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.sqxx;

import cn.gtmap.estateplat.register.common.util.DesensitizedUtils;
import cn.gtmap.hlw.core.domain.sqxx.SqxxSaveEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.SqxxSaveModel;
import cn.gtmap.hlw.core.enums.dict.GyfsEnum;
import cn.gtmap.hlw.core.enums.dict.JtgxEnum;
import cn.gtmap.hlw.core.enums.dict.ZjlxEnum;
import cn.gtmap.hlw.core.enums.dict.fw.FwtcEnum;
import cn.gtmap.hlw.core.enums.qlr.QlrCodeEnum;
import cn.gtmap.hlw.core.enums.status.Status2Enum;
import cn.gtmap.hlw.core.model.GxYyOrg;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYyQlrGxr;
import cn.gtmap.hlw.core.model.GxYyQlrJhr;
import cn.gtmap.hlw.core.model.GxYyQlrJtcy;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.repository.GxYyOrgRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrGxrRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrJhrRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrJtcyRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYyRoleOrgRelRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.gtmap.hlw.core.util.validator.IdCardVailatorUtils;
import cn.hutool.core.collection.CollUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QlrSaveEvent
implements SqxxSaveEventService {
    @Autowired
    GxYyOrgRepository gxYyOrgRepository;
    @Autowired
    GxYyQlrRepository gxYyQlrRepository;
    @Autowired
    GxYyQlrJtcyRepository gxYyQlrJtcyRepository;
    @Autowired
    GxYyQlrJhrRepository gxYyQlrJhrRepository;
    @Autowired
    GxYyQlrGxrRepository gxYyQlrGxrRepository;
    @Autowired
    GxYyRoleOrgRelRepository gxYyRoleOrgRelRepository;
    @Autowired
    RedisRepository redisRepository;

    public void doWork(SqxxSaveModel sqxxSaveModel) {
        if (sqxxSaveModel.getFwxx() == null) {
            return;
        }
        String fwyt = sqxxSaveModel.getFwxx().getFwyt();
        GxYySqxx sqxx = sqxxSaveModel.getSqxx();
        String sqid = sqxx.getSqid();
        List qlrList = sqxxSaveModel.getQlrList();
        this.updateQlrListWithSfyq(qlrList);
        if (CollectionUtils.isNotEmpty((Collection)qlrList)) {
            List qlrzjhList = qlrList.stream().map(GxYyQlr::getQlrzjh).collect(Collectors.toList());
            this.delQlrxx(sqid);
            List orgList = this.gxYyOrgRepository.listByTyxydm(qlrzjhList);
            ArrayList jtcyList = Lists.newArrayList();
            ArrayList jhrList = Lists.newArrayList();
            ArrayList gxrList = Lists.newArrayList();
            for (GxYyQlr gxYyQlr : qlrList) {
                List gxYyQlrJhrList;
                List gxYyQlrJtcyList;
                boolean status;
                gxYyQlr.setSqid(sqid);
                if (StringUtils.isBlank((CharSequence)gxYyQlr.getQlrid())) {
                    gxYyQlr.setQlrid(StringUtil.hex32());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{gxYyQlr.getFddbrhfzr(), gxYyQlr.getFddbrhfzrzjh()}) && StringUtils.isBlank((CharSequence)gxYyQlr.getFddbrhfzrid())) {
                    gxYyQlr.setFddbrhfzrid(StringUtil.hex32());
                }
                boolean bl = status = StringUtils.isNotBlank((CharSequence)gxYyQlr.getQlrsfzjzl()) || StringUtils.isNotBlank((CharSequence)gxYyQlr.getQlrzjh());
                if (status) {
                    boolean isGr = StringUtil.isEquals((String)gxYyQlr.getQlrsfzjzl(), (String[])new String[]{ZjlxEnum.SFZJZL_SFZ.getCode(), ZjlxEnum.SFZJZL_GASFZ.getCode(), ZjlxEnum.SFZJZL_HZ.getCode(), ZjlxEnum.SFZJZL_HKB.getCode(), ZjlxEnum.SFZJZL_JGZ.getCode(), ZjlxEnum.SFZJZL_WGRYJJLZ.getCode()});
                    GxYyOrg org = (GxYyOrg)CollUtil.findOne((Iterable)orgList, gxYyOrg -> StringUtils.equals((CharSequence)gxYyOrg.getOrgTyxydm(), (CharSequence)gxYyQlr.getQlrzjh()));
                    if (org != null) {
                        if (StringUtils.isBlank((CharSequence)gxYyQlr.getSfyj())) {
                            gxYyQlr.setSfyj(StringUtils.isNotBlank((CharSequence)org.getSfyj()) ? org.getSfyj() : Status2Enum.NO.getCode());
                        }
                        this.updateSfyj(org, gxYyQlr);
                        if (StringUtils.isBlank((CharSequence)gxYyQlr.getSfxwqy())) {
                            gxYyQlr.setSfxwqy(StringUtils.isNotBlank((CharSequence)org.getSfxwqy()) ? org.getSfxwqy() : Status2Enum.NO.getCode());
                        }
                        if (StringUtils.isBlank((CharSequence)gxYyQlr.getGxrzldm())) {
                            gxYyQlr.setGxrzldm(QlrCodeEnum.QLRZL_QY.getCode());
                        }
                    } else if (isGr && StringUtils.isBlank((CharSequence)gxYyQlr.getGxrzldm())) {
                        gxYyQlr.setGxrzldm(QlrCodeEnum.QLRZL_GR.getCode());
                    }
                }
                if (StringUtils.isBlank((CharSequence)gxYyQlr.getSfyj())) {
                    gxYyQlr.setSfyj(Status2Enum.NO.getCode());
                }
                if (!StringUtils.equals((CharSequence)gxYyQlr.getGyfs(), (CharSequence)GyfsEnum.AFGY.getCode())) {
                    gxYyQlr.setQlbl("");
                }
                if (CollectionUtils.isNotEmpty((Collection)(gxYyQlrJtcyList = gxYyQlr.getJtcyList()))) {
                    gxYyQlrJtcyList = gxYyQlrJtcyList.stream().collect(Collectors.toMap(item -> item.getJtcyzjh() + "_" + item.getJtcymc(), item -> item, (existing, replacement) -> existing)).values().stream().collect(Collectors.toList());
                    for (GxYyQlrJtcy gxYyQlrJtcy : gxYyQlrJtcyList) {
                        gxYyQlrJtcy.setQlrid(gxYyQlr.getQlrid());
                        gxYyQlrJtcy.setSqid(gxYyQlr.getSqid());
                    }
                    jtcyList.addAll(gxYyQlrJtcyList);
                }
                if (CollectionUtils.isNotEmpty((Collection)(gxYyQlrJhrList = gxYyQlr.getJhrList()))) {
                    GxYyQlrJtcy gxYyQlrJtcy;
                    gxYyQlrJtcy = gxYyQlrJhrList.iterator();
                    while (gxYyQlrJtcy.hasNext()) {
                        GxYyQlrJhr gxYyQlrJhr = (GxYyQlrJhr)gxYyQlrJtcy.next();
                        gxYyQlrJhr.setJhrid(StringUtil.hex32());
                        gxYyQlrJhr.setSqid(gxYyQlr.getSqid());
                        gxYyQlrJhr.setQlrid(gxYyQlr.getQlrid());
                    }
                    jhrList.addAll(gxYyQlrJhrList);
                }
                this.setFwtc(sqxx, gxYyQlr, fwyt);
                GxYyQlrGxr qlrGxr = (GxYyQlrGxr)BeanConvertUtil.getBeanByJsonObj((Object)gxYyQlr, GxYyQlrGxr.class);
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qlrGxr.getGxrmc(), qlrGxr.getGxrzjh()})) continue;
                qlrGxr.setGxrid(StringUtil.hex32());
                qlrGxr.setSqid(sqid);
                qlrGxr.setSlbh(sqxx.getSlbh());
                qlrGxr.setGxrlx("1");
                DesensitizedUtils.getBeanByJsonObj((Object)qlrGxr, GxYyQlrGxr.class, (String)"dataTm");
                gxrList.add(qlrGxr);
            }
            if (CollectionUtils.isNotEmpty((Collection)jtcyList)) {
                for (GxYyQlrJtcy gxYyQlrJtcy : jtcyList) {
                    if (!StringUtils.isBlank((CharSequence)gxYyQlrJtcy.getJtgx())) continue;
                    Boolean flag = IdCardVailatorUtils.checkCn((String)gxYyQlrJtcy.getJtcyzjh());
                    gxYyQlrJtcy.setJtgx(flag != false ? JtgxEnum.JTGX_PO.getCode() : JtgxEnum.JTGX_WCNZN.getCode());
                }
                this.gxYyQlrJtcyRepository.saveOrUpdateBatch((List)jtcyList);
            }
            if (CollectionUtils.isNotEmpty((Collection)jhrList)) {
                this.gxYyQlrJhrRepository.saveOrUpdateBatch((List)jhrList);
            }
            if (CollectionUtils.isNotEmpty((Collection)gxrList)) {
                this.gxYyQlrGxrRepository.saveOrUpdateBatch((List)gxrList);
            }
            Map<String, List<GxYyQlr>> qlrListMap = qlrList.stream().collect(Collectors.groupingBy(GxYyQlr::getQlrlx));
            for (String qlrlx : qlrListMap.keySet()) {
                int sxh = 1;
                List<GxYyQlr> gxYyQlrList = qlrListMap.get(qlrlx);
                for (GxYyQlr gxYyQlr : gxYyQlrList) {
                    while (this.checkSxh(sxh, gxYyQlrList)) {
                        ++sxh;
                    }
                    if (!StringUtils.isBlank((CharSequence)gxYyQlr.getSxh())) continue;
                    gxYyQlr.setSxh(String.valueOf(sxh));
                    ++sxh;
                }
            }
            this.gxYyQlrRepository.saveOrUpdateBatch(qlrList);
        }
    }

    private boolean checkSxh(int sxh, List<GxYyQlr> gxYyQlrList) {
        boolean sfsy = false;
        if (CollectionUtils.isNotEmpty((Collection)gxYyQlrList.stream().filter(gxYyQlr -> StringUtils.equals((CharSequence)gxYyQlr.getSxh(), (CharSequence)String.valueOf(sxh))).collect(Collectors.toList()))) {
            sfsy = true;
        }
        return sfsy;
    }

    private void updateSfyj(GxYyOrg org, GxYyQlr gxYyQlr) {
        Boolean sfyjBylc = this.redisRepository.getBoolean("yc.sfyj.by.lc", Boolean.valueOf(false));
        if (sfyjBylc.booleanValue() && StringUtils.equals((CharSequence)org.getSfyj(), (CharSequence)Status2Enum.NO.getCode())) {
            gxYyQlr.setSfyj(org.getSfyj());
        }
    }

    private void updateQlrListWithSfyq(List<GxYyQlr> qlrList) {
        boolean isCheckYqButton = false;
        for (GxYyQlr gxYyQlr : qlrList) {
            if (!StringUtils.isNotBlank((CharSequence)gxYyQlr.getSfyq())) continue;
            isCheckYqButton = true;
            break;
        }
        if (isCheckYqButton) {
            for (GxYyQlr gxYyQlr : qlrList) {
                if (!StringUtils.isBlank((CharSequence)gxYyQlr.getSfyq())) continue;
                gxYyQlr.setSfyq(Status2Enum.NO.getCode());
            }
        }
    }

    private void setFwtc(GxYySqxx sqxx, GxYyQlr gxYyQlr, String fwyt) {
        if (StringUtils.isBlank((CharSequence)gxYyQlr.getFwtc())) {
            String fcFwyt;
            String djyys = StringUtil.toString((Object)this.redisRepository.get("yc.not.need.fc.djyy"));
            if (StringUtils.isNotBlank((CharSequence)djyys) && StringUtil.indexOfStrs((String[])djyys.split(","), (String)sqxx.getDjyy())) {
                gxYyQlr.setFwtc(FwtcEnum.FWTC_QTT.getCode());
            }
            if (StringUtils.isNotBlank((CharSequence)(fcFwyt = StringUtil.toString((Object)this.redisRepository.get("yc.need.fc.fwyt")))) && !StringUtil.indexOfStrs((String[])fcFwyt.split(","), (String)fwyt)) {
                gxYyQlr.setFwtc(FwtcEnum.FWTC_QTT.getCode());
            }
            if (StringUtils.equalsAny((CharSequence)gxYyQlr.getQlrsfzjzl(), (CharSequence[])new CharSequence[]{ZjlxEnum.SFZJZL_ZHJGDM.getCode(), ZjlxEnum.SFZJZL_YYZZ.getCode(), ZjlxEnum.SFZJZL_TYSHXYDM.getCode()})) {
                gxYyQlr.setFwtc(FwtcEnum.FWTC_QTT.getCode());
            }
        }
    }

    private void delQlrxx(String sqid) {
        List qlrList = this.gxYyQlrRepository.list(sqid);
        if (CollectionUtils.isNotEmpty((Collection)qlrList)) {
            List gxrList;
            List jhrList;
            List qlrIdList = qlrList.stream().map(GxYyQlr::getQlrid).collect(Collectors.toList());
            List jtcyList = this.gxYyQlrJtcyRepository.getListByQlrids(qlrIdList);
            if (CollectionUtils.isNotEmpty((Collection)jtcyList)) {
                this.gxYyQlrJtcyRepository.deleteByQlrids(qlrIdList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(jhrList = this.gxYyQlrJhrRepository.getListByQlrids(qlrIdList)))) {
                this.gxYyQlrJhrRepository.deleteByQlrids(qlrIdList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(gxrList = this.gxYyQlrGxrRepository.getListByQlrids(qlrIdList)))) {
                this.gxYyQlrGxrRepository.deleteByQlrids(qlrIdList);
            }
            this.gxYyQlrRepository.deleteBySqid(sqid);
        }
    }
}

