/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.sqxx;

import cn.gtmap.hlw.core.domain.sqxx.SqxxSaveEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.SqxxSaveModel;
import cn.gtmap.hlw.core.enums.dict.JtgxEnum;
import cn.gtmap.hlw.core.enums.status.Status2Enum;
import cn.gtmap.hlw.core.model.GxYyJtcy;
import cn.gtmap.hlw.core.repository.GxYyJtcyRepository;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.gtmap.hlw.core.util.validator.IdCardVailatorUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JtSaveEvent
implements SqxxSaveEventService {
    @Autowired
    private GxYyJtcyRepository gxYyJtcyRepository;

    public void doWork(SqxxSaveModel sqxxSaveModel) {
        List jtList = sqxxSaveModel.getJtList();
        if (CollectionUtils.isNotEmpty((Collection)jtList)) {
            String sqid = sqxxSaveModel.getSqxx().getSqid();
            this.gxYyJtcyRepository.delBySqid(sqid);
            for (GxYyJtcy gxYyJtcy : jtList) {
                gxYyJtcy.setId(StringUtil.hex32());
                gxYyJtcy.setStatus(Status2Enum.YES.getCode());
                if (StringUtils.isBlank((CharSequence)gxYyJtcy.getJtgx())) {
                    Boolean flag = IdCardVailatorUtils.checkCn((String)gxYyJtcy.getJtcyzjh());
                    gxYyJtcy.setJtgx(flag != false ? JtgxEnum.JTGX_PO.getCode() : JtgxEnum.JTGX_WCNZN.getCode());
                }
                gxYyJtcy.setSqid(sqid);
            }
            this.gxYyJtcyRepository.saveBatch(jtList);
        }
    }
}

