/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.qlr.hq;

import cn.gtmap.hlw.core.domain.sqxx.QlrHqEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.qlr.QlrHqParamsModel;
import cn.gtmap.hlw.core.enums.dict.SfrzEnum;
import cn.gtmap.hlw.core.enums.qlr.QlrTypeEnum;
import cn.gtmap.hlw.core.enums.sqxx.SfqzEnum;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYyQlrJhr;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYySqxxHq;
import cn.gtmap.hlw.core.repository.GxYyQlrJhrRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxHqRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdSqlxRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QlrHqQlrWhyAndWyqEvent
implements QlrHqEventService {
    @Autowired
    GxYySqxxRepository sqxxRepository;
    @Autowired
    GxYyZdSqlxRepository gxYyZdSqlxRepository;
    @Autowired
    GxYyQlrRepository gxYyQlrRepository;
    @Autowired
    GxYyQlrJhrRepository gxYyQlrJhrRepository;
    @Autowired
    GxYySqxxHqRepository gxYySqxxHqRepository;

    public void doWork(QlrHqParamsModel paramsModel) {
        List sqxxList = paramsModel.getSqxxList();
        List zyList = Lists.newArrayList();
        zyList = sqxxList.size() == 1 ? sqxxList : this.sqxxRepository.getSqxxZyBySqxxList(paramsModel.getSqxxList());
        if (CollectionUtils.isEmpty((Collection)zyList)) {
            return;
        }
        List sqidList = zyList.stream().map(GxYySqxx::getSqid).collect(Collectors.toList());
        List qlrList = this.gxYyQlrRepository.getBySqidListAndQlrlx(sqidList, QlrTypeEnum.QLRLX_QLR.getCode());
        List<Object> qlrIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)qlrList)) {
            qlrIds = qlrList.stream().map(GxYyQlr::getQlrid).collect(Collectors.toList());
        }
        List hqList = this.gxYySqxxHqRepository.getByQlrIdList((List)qlrIds);
        ArrayList batchUpdateList = Lists.newArrayList();
        ArrayList insertHqList = Lists.newArrayList();
        ArrayList addQlrIdList = Lists.newArrayList();
        for (GxYyQlr gxYyQlr : qlrList) {
            for (GxYySqxxHq gxYySqxxHq : hqList) {
                if (StringUtils.equals((CharSequence)gxYyQlr.getQlrid(), (CharSequence)gxYySqxxHq.getQlrid())) {
                    gxYySqxxHq.setSfrz(SfrzEnum.SFRZ_WRZ.getCode());
                    gxYySqxxHq.setSfqz(SfqzEnum.SAQZ_NO.getCode());
                    batchUpdateList.add(gxYySqxxHq);
                    continue;
                }
                GxYySqxxHq insertHq = (GxYySqxxHq)BeanConvertUtil.getBeanByJsonObj((Object)gxYyQlr, GxYySqxxHq.class);
                insertHqList.add(insertHq);
                addQlrIdList.add(insertHq.getQlrid());
            }
        }
        List jhrList = this.gxYyQlrJhrRepository.getByQlridList((List)addQlrIdList);
        for (GxYySqxxHq gxYySqxxHq : insertHqList) {
            for (GxYyQlrJhr gxYyQlrJhr : jhrList) {
                if (!StringUtils.equals((CharSequence)gxYySqxxHq.getQlrid(), (CharSequence)gxYyQlrJhr.getQlrid())) continue;
                gxYySqxxHq.setJhrid(gxYyQlrJhr.getJhrid());
                batchUpdateList.add(gxYySqxxHq);
            }
        }
        this.gxYySqxxHqRepository.saveOrUpdateBatch((List)batchUpdateList);
    }
}

