/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.qlr.hq;

import cn.gtmap.hlw.core.domain.sqxx.QlrHqEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.qlr.QlrHqParamsModel;
import cn.gtmap.hlw.core.enums.dict.SfrzEnum;
import cn.gtmap.hlw.core.enums.qlr.QlrTypeEnum;
import cn.gtmap.hlw.core.enums.sqxx.SfqzEnum;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYySqxxHq;
import cn.gtmap.hlw.core.repository.GxYyQlrJhrRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxHqRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdSqlxRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QlrHqDyqrDhyAndDyqEvent
implements QlrHqEventService {
    private static final Logger log = LoggerFactory.getLogger(QlrHqDyqrDhyAndDyqEvent.class);
    @Autowired
    GxYySqxxRepository sqxxRepository;
    @Autowired
    GxYyZdSqlxRepository gxYyZdSqlxRepository;
    @Autowired
    GxYyQlrRepository gxYyQlrRepository;
    @Autowired
    GxYyQlrJhrRepository gxYyQlrJhrRepository;
    @Autowired
    GxYySqxxHqRepository gxYySqxxHqRepository;

    public void doWork(QlrHqParamsModel paramsModel) {
        List dyList = Lists.newArrayList();
        dyList = CollectionUtils.isNotEmpty((Collection)paramsModel.getSqxxList()) ? this.sqxxRepository.getSqxxDyBySqxxList(paramsModel.getSqxxList()) : this.sqxxRepository.getSqxxDyBySlbh(paramsModel.getSlbh());
        log.info("QlrHqDyqrDhyAndDyqEvent -->\u83b7\u53d6\u5230\u7684\u62b5\u62bc\u4fe1\u606f\uff1a{}", (Object)dyList);
        if (CollectionUtils.isEmpty((Collection)dyList)) {
            return;
        }
        List sqidList = dyList.stream().map(GxYySqxx::getSqid).collect(Collectors.toList());
        List qlrList = this.gxYyQlrRepository.getBySqidListAndQlrlx(sqidList, QlrTypeEnum.QLRLX_QLR.getCode());
        log.info("QlrHqDyqrDhyAndDyqEvent -->\u6839\u636e\u7533\u8bf7ID\uff1a{}\u67e5\u8be2\u5230\u7684\u6743\u5229\u4eba\u4fe1\u606f\uff1a{}", sqidList, (Object)qlrList);
        List<Object> qlrIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)qlrList)) {
            qlrIds = qlrList.stream().map(GxYyQlr::getQlrid).collect(Collectors.toList());
        }
        List hqList = this.gxYySqxxHqRepository.getByQlrIdList((List)qlrIds);
        log.info("QlrHqDyqrDhyAndDyqEvent -->\u6839\u636e\u6743\u5229\u4ebaID\uff1a{}\u67e5\u8be2\u5230\u7684\u4f1a\u7b7e\u4fe1\u606f\uff1a{}", (Object)qlrIds, (Object)hqList);
        ArrayList batchUpdateList = Lists.newArrayList();
        for (GxYyQlr gxYyQlr : qlrList) {
            if (CollectionUtils.isNotEmpty((Collection)hqList)) {
                for (GxYySqxxHq gxYySqxxHq : hqList) {
                    if (StringUtils.equals((CharSequence)gxYyQlr.getQlrid(), (CharSequence)gxYySqxxHq.getQlrid())) {
                        gxYySqxxHq.setSfrz(SfrzEnum.SFRZ_DRZ_YH.getCode());
                        gxYySqxxHq.setSfqz(SfqzEnum.SAQZ_NO.getCode());
                        batchUpdateList.add(gxYySqxxHq);
                        continue;
                    }
                    GxYySqxxHq insertHq = (GxYySqxxHq)BeanConvertUtil.getBeanByJsonObj((Object)gxYyQlr, GxYySqxxHq.class);
                    insertHq.setSfrz(SfrzEnum.SFRZ_DRZ_YH.getCode());
                    insertHq.setSfqz(SfqzEnum.SAQZ_NO.getCode());
                    batchUpdateList.add(insertHq);
                }
                continue;
            }
            GxYySqxxHq insertHq = (GxYySqxxHq)BeanConvertUtil.getBeanByJsonObj((Object)gxYyQlr, GxYySqxxHq.class);
            insertHq.setSfrz(SfrzEnum.SFRZ_DRZ_YH.getCode());
            insertHq.setSfqz(SfqzEnum.SAQZ_NO.getCode());
            batchUpdateList.add(insertHq);
        }
        this.gxYySqxxHqRepository.saveOrUpdateBatch((List)batchUpdateList);
    }
}

