/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.push;

import cn.gtmap.hlw.core.domain.sqxx.PushSqxxEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.push.PushSqxxEventResultModel;
import cn.gtmap.hlw.core.domain.sqxx.model.push.PushSqxxParamsModel;
import cn.gtmap.hlw.core.domain.sqxx.model.push.PushSqxxResultModel;
import cn.gtmap.hlw.core.enums.dict.SlztEnum;
import cn.gtmap.hlw.core.enums.dict.XxlxEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.enums.sqxx.YwlxEnum;
import cn.gtmap.hlw.core.enums.status.Status2Enum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYyWdxx;
import cn.gtmap.hlw.core.repository.GxYySqxxKzRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyWdxxRepository;
import cn.gtmap.hlw.core.util.string.StringUtil;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PushSqxxAfterUpdateSlztEvent
implements PushSqxxEventService {
    private static final Logger log = LoggerFactory.getLogger(PushSqxxAfterUpdateSlztEvent.class);
    @Resource
    private GxYySqxxRepository gxYySqxxRepository;
    @Resource
    private GxYySqxxKzRepository gxYySqxxKzRepository;
    @Resource
    private GxYyWdxxRepository gxYyWdxxRepository;
    private static final Integer SLXX_MAX_LENGTH = 1999;

    public PushSqxxEventResultModel doWork(PushSqxxParamsModel paramsModel, PushSqxxResultModel resultModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getSlbh())) {
            throw new BizException(ErrorEnum.PARAM_NULL.getCode(), "\u53d7\u7406\u7f16\u53f7\u4e3a\u7a7a");
        }
        GxYySqxx gxYySqxx = new GxYySqxx();
        gxYySqxx.setSlbh(paramsModel.getSlbh());
        if (ErrorEnum.SUCCESS.getCode().equals(resultModel.getCode())) {
            gxYySqxx.setSlzt(Integer.valueOf(SlztEnum.SLZT_SHZ.getCode()));
            gxYySqxx.setYwxtslbh(resultModel.getYwslbh());
            gxYySqxx.setProid(resultModel.getProid());
            gxYySqxx.setDjxtcjsj(new Date());
            gxYySqxx.setDjjsrmc(resultModel.getJsrmc());
            if (StringUtils.isNotBlank((CharSequence)resultModel.getProid())) {
                List sqidList = this.gxYySqxxRepository.list(paramsModel.getSlbh()).stream().map(GxYySqxx::getSqid).collect(Collectors.toList());
                this.gxYySqxxKzRepository.updateProid(sqidList, resultModel.getProid());
            }
        } else {
            gxYySqxx.setSlzt(Integer.valueOf(SlztEnum.SLZT_TSSB.getCode()));
            if (StringUtils.isNotBlank((CharSequence)resultModel.getMsg()) && resultModel.getMsg().length() > SLXX_MAX_LENGTH) {
                gxYySqxx.setSlxx(resultModel.getMsg().substring(0, SLXX_MAX_LENGTH));
            } else {
                gxYySqxx.setSlxx(resultModel.getMsg());
            }
            GxYySqxx sqxx = this.gxYySqxxRepository.getSqxxOneBySlbh(paramsModel.getSlbh());
            if (sqxx != null) {
                gxYySqxx.setCreateUserid(sqxx.getCreateUserid());
            }
            this.saveWdxx(gxYySqxx);
        }
        log.info("{} \u63a8\u9001\u540e\u66f4\u65b0SLZT:{}", (Object)paramsModel.getSlbh(), (Object)gxYySqxx.getSlzt());
        this.gxYySqxxRepository.updateSqxx(gxYySqxx);
        return null;
    }

    public void saveWdxx(GxYySqxx gxYySqxx) {
        GxYyWdxx gxYyWdxx = GxYyWdxx.builder().id(StringUtil.hex32()).xxlx(XxlxEnum.XXLX_SQXXTSDJXTJGTZ.getCode()).cjr("\u7cfb\u7edf\u63d0\u793a").jsr(gxYySqxx.getCreateUserid()).ywh(gxYySqxx.getSlbh()).bt("\u7533\u8bf7\u4fe1\u606f\u63a8\u9001\u81f3\u767b\u8bb0\u7cfb\u7edf\u7ed3\u679c\u901a\u77e5").nr("\u7533\u8bf7\u4fe1\u606f\u63a8\u9001\u81f3\u767b\u8bb0\u7cfb\u7edf\u5931\u8d25\uff1a\u53d7\u7406\u7f16\u53f7\uff1a" + gxYySqxx.getSlbh() + "\uff1b\u5931\u8d25\u539f\u56e0\uff1a" + gxYySqxx.getSlxx()).sfyd(Status2Enum.NO.getCode()).cjsj(new Date()).ywlx(YwlxEnum.YWLX_SQXX.getCode()).build();
        try {
            this.gxYyWdxxRepository.save(gxYyWdxx);
        }
        catch (Exception e) {
            log.error("saveWdxx:", (Throwable)e);
        }
    }
}

