/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.htxx;

import cn.gtmap.hlw.core.domain.fj.FjEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjEventParamsModel;
import cn.gtmap.hlw.core.domain.sqxx.SqxxHtxxSaveEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.htxx.SqxxHtxxFjxxModel;
import cn.gtmap.hlw.core.domain.sqxx.model.htxx.SqxxHtxxSaveParamsModel;
import cn.gtmap.hlw.core.domain.sqxx.model.htxx.SqxxHtxxSaveResultModel;
import cn.gtmap.hlw.core.enums.dict.fj.FjlxEnum;
import cn.gtmap.hlw.core.enums.dict.fj.FjlyEnum;
import cn.gtmap.hlw.core.model.GxYyFjxm;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYyZdFj;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdFjRepository;
import cn.gtmap.hlw.core.repository.GxYyZdSqlxRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.http.HttpUtil;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.gtmap.hlw.core.util.thread.ThreadPoolMdcExecutor;
import cn.gtmap.hlw.domain.fj.event.FjxxDomainService;
import com.alibaba.fastjson.JSON;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SqxxHtxxSaveHtxxFjxxEvent
implements SqxxHtxxSaveEventService {
    private static final Logger log = LoggerFactory.getLogger(SqxxHtxxSaveHtxxFjxxEvent.class);
    @Autowired
    GxYyFjxmRepository gxYyFjxmRepository;
    @Autowired
    GxYyFjxxRepository gxYyFjxxRepository;
    @Autowired
    RedisRepository redisRepository;
    @Resource
    private FjEventService fjEventService;
    @Resource
    private FjxxDomainService fjxxDomainService;
    @Resource
    GxYyFjxmRepository fjxmRepository;
    @Resource
    GxYyZdFjRepository zdFjRepository;
    @Resource
    GxYySqxxRepository gxYySqxxRepository;
    @Resource
    GxYyZdSqlxRepository gxYyZdSqlxRepository;
    @Resource
    HlwPzPzxRepository hlwPzPzxRepository;

    public void doWork(SqxxHtxxSaveParamsModel saveParamsModel, SqxxHtxxSaveResultModel resultModel) {
        List fjxxList = saveParamsModel.getFjxxList();
        if (CollectionUtils.isNotEmpty((Collection)fjxxList)) {
            GxYySqxx gxYySqxx = this.gxYySqxxRepository.get(saveParamsModel.getSqid());
            for (SqxxHtxxFjxxModel sqxxHtxxFjxxModel : fjxxList) {
                if (StringUtils.isNotBlank((CharSequence)sqxxHtxxFjxxModel.getFjnr())) {
                    String slbh = saveParamsModel.getSlbh();
                    String sqid = saveParamsModel.getSqid();
                    String fjlx = String.valueOf(FjlxEnum.FJLX_JYHT.getCode());
                    String fileName = sqxxHtxxFjxxModel.getFjmc();
                    String fjly = FjlyEnum.FJLY_JYXT.getDm();
                    if (gxYySqxx != null) {
                        slbh = gxYySqxx.getSlbh();
                    }
                    if (StringUtils.isNotBlank((CharSequence)slbh)) {
                        this.saveFjxm(slbh, sqid, fjlx);
                        FjEventParamsModel fjEventParamsModel = new FjEventParamsModel();
                        fjEventParamsModel.setLysjdm("lysjdm.fj.upload");
                        fjEventParamsModel.setBase64(sqxxHtxxFjxxModel.getFjnr());
                        fjEventParamsModel.setSqid(sqid);
                        fjEventParamsModel.setFjlx(fjlx);
                        fjEventParamsModel.setFileName(fileName);
                        fjEventParamsModel.setSlbh(slbh);
                        fjEventParamsModel.setFjly(fjly);
                        this.fjxxDomainService.event(fjEventParamsModel);
                        continue;
                    }
                    log.info("\u5408\u540c\u9644\u4ef6\u4fe1\u606f\u4fdd\u5b58 \u7f3a\u5931slbh");
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)sqxxHtxxFjxxModel.getFjurl())) continue;
                String qydm = gxYySqxx != null ? gxYySqxx.getQydm() : null;
                String fjurl = sqxxHtxxFjxxModel.getFjurl();
                String ip = StringUtil.toString((Object)this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKeyAndQydm("yc.ht.fj.ip", qydm));
                if (StringUtils.isNotBlank((CharSequence)ip)) {
                    fjurl = this.replaceIp(fjurl, ip);
                }
                String finalFjurl = fjurl;
                ThreadPoolMdcExecutor.execute(() -> {
                    String base64 = HttpUtil.doGetForBase64((String)finalFjurl, null, null);
                    if (StringUtils.isNotBlank((CharSequence)base64)) {
                        this.fjEventService.uploadFileFromBase64(base64, saveParamsModel.getSqid(), String.valueOf(FjlxEnum.FJLX_JYHT.getCode()), sqxxHtxxFjxxModel.getFjmc(), saveParamsModel.getSlbh(), FjlyEnum.FJLY_JYXT.getDm(), "");
                    }
                });
            }
        }
    }

    public String replaceIp(String url, String ip) {
        URI uri = null;
        try {
            uri = new URI(url);
            URI newUri = new URI(uri.getScheme(), uri.getUserInfo(), ip.split(":")[0], Integer.parseInt(ip.split(":")[1]), uri.getPath(), uri.getQuery(), uri.getFragment());
            return newUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void saveFjxm(String slbh, String sqid, String fjlx) {
        GxYyFjxm gxYyFjxm = this.fjxmRepository.getBySlbhAndFjlx(slbh, fjlx);
        log.info("\u5408\u540c\u9644\u4ef6\u4fe1\u606f\u4fdd\u5b58 fjxm\u662f\u5426\u5b58\u5728:{}", (Object)JSON.toJSONString((Object)gxYyFjxm));
        if (null == gxYyFjxm) {
            List sqlxList;
            GxYyZdFj gxYyZdFj;
            gxYyFjxm = new GxYyFjxm();
            gxYyFjxm.setSlbh(slbh);
            gxYyFjxm.setXmid(StringUtil.hex32());
            gxYyFjxm.setSqid(sqid);
            gxYyFjxm.setFjlx(fjlx);
            gxYyFjxm.setFjlxmc(FjlxEnum.getMsg((String)fjlx));
            GxYySqxx gxYySqxx = this.gxYySqxxRepository.get(sqid);
            if (gxYySqxx != null && StringUtils.isNotBlank((CharSequence)gxYySqxx.getSqlx()) && (gxYyZdFj = this.zdFjRepository.getBySqlxListAndFjlx(sqlxList = this.gxYyZdSqlxRepository.getSqlxListBySqlx(gxYySqxx.getSqlx()), fjlx)) != null) {
                gxYyFjxm.setFjlxmc(gxYyZdFj.getMc());
                gxYyFjxm.setCllx(gxYyZdFj.getMrfjlx());
                gxYyFjxm.setClfs(gxYyZdFj.getMrfjfs());
                gxYyFjxm.setClys(gxYyZdFj.getMrfjys());
            }
            this.fjxmRepository.save(gxYyFjxm);
        }
    }
}

