/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.commit;

import cn.gtmap.hlw.core.domain.sign.SignFlowCommonService;
import cn.gtmap.hlw.core.domain.sqxx.SqxxCommitEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.commit.QlrModel;
import cn.gtmap.hlw.core.domain.sqxx.model.commit.SqxxCommitParamsModel;
import cn.gtmap.hlw.core.domain.sqxx.model.commit.SqxxCommitResultModel;
import cn.gtmap.hlw.core.enums.JddmEnum;
import cn.gtmap.hlw.core.enums.dict.SfrzEnum;
import cn.gtmap.hlw.core.enums.qlr.QlrTypeEnum;
import cn.gtmap.hlw.core.enums.sqxx.SfqzEnum;
import cn.gtmap.hlw.core.enums.status.Status2Enum;
import cn.gtmap.hlw.core.enums.status.StatusEnum;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYySqxxHq;
import cn.gtmap.hlw.core.model.GxYyZdSqlx;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxZtRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxHqRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxKzRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdSqlxRepository;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SqxxCommitInsertQlrYwrHqxxEvent
implements SqxxCommitEventService {
    private static final Logger log = LoggerFactory.getLogger(SqxxCommitInsertQlrYwrHqxxEvent.class);
    @Autowired
    GxYySqxxHqRepository gxYySqxxHqRepository;
    @Autowired
    GxYySqxxRepository gxYySqxxRepository;
    @Autowired
    GxYyQlrRepository gxYyQlrRepository;
    @Autowired
    GxYyZdSqlxRepository gxYyZdSqlxRepository;
    @Resource
    private GxYySqxxKzRepository gxYySqxxKzRepository;
    @Resource
    private SignFlowCommonService signFlowCommonService;
    @Resource
    private GxYySqlxJdxxZtRepository gxYySqlxJdxxZtRepository;

    public void doWork(SqxxCommitParamsModel paramsModel, SqxxCommitResultModel resultModel) {
        List sqxxList = paramsModel.getGxYySqxxList();
        if (CollectionUtils.isNotEmpty((Collection)sqxxList)) {
            ArrayList list = Lists.newArrayList();
            ArrayList qlrModelList = Lists.newArrayList();
            List sqidList = sqxxList.stream().map(GxYySqxx::getSqid).collect(Collectors.toList());
            List sqdjlxList = sqxxList.stream().map(GxYySqxx::getSqdjlx).collect(Collectors.toList());
            List zdSqlxList = this.gxYyZdSqlxRepository.getSqlxBySqlxdmList((List)CollUtil.distinct(sqdjlxList));
            List gxYyQlrList = this.gxYyQlrRepository.list(sqidList);
            boolean isSkipSignFlow = this.signFlowCommonService.isSkipSignFlow(sqxxList);
            if (isSkipSignFlow) {
                JddmEnum.getYqjddmList().forEach(jddm -> this.gxYySqlxJdxxZtRepository.updateNoNeedExecute(paramsModel.getSlbh(), jddm));
            }
            if (CollectionUtils.isNotEmpty((Collection)gxYyQlrList)) {
                for (GxYyQlr gxYyQlr : gxYyQlrList) {
                    int sfrz;
                    GxYySqxx gxYySqxx = (GxYySqxx)CollUtil.findOneByField((Iterable)sqxxList, (String)"sqid", (Object)gxYyQlr.getSqid());
                    GxYyZdSqlx zdSqlx = (GxYyZdSqlx)CollUtil.findOneByField((Iterable)zdSqlxList, (String)"dm", (Object)gxYySqxx.getSqdjlx());
                    GxYySqxxHq gxYySqxxHq = new GxYySqxxHq();
                    gxYySqxxHq.setQlrid(gxYyQlr.getQlrid());
                    gxYySqxxHq.setSlbh(gxYySqxx.getSlbh());
                    int n = sfrz = StringUtils.equals((CharSequence)paramsModel.getUsername(), (CharSequence)gxYyQlr.getQlrmc()) ? Integer.parseInt(StatusEnum.TRUE.getCode()) : this.getSfrz(zdSqlx, gxYyQlr);
                    if (StatusEnum.FALSE.getCode().equals(gxYyQlr.getSfxyhy())) {
                        sfrz = SfrzEnum.SFRZ_RZTG.getCode();
                    }
                    gxYySqxxHq.setSfrz(Integer.valueOf(sfrz));
                    gxYySqxxHq.setRzTime(new Date());
                    String sfqz = isSkipSignFlow ? SfqzEnum.SAQZ_SUCCESS.getCode() : this.getSfqz(zdSqlx, gxYyQlr);
                    gxYySqxxHq.setSfqz(sfqz);
                    list.add(gxYySqxxHq);
                    if (!NumberUtil.equals((long)sfrz, (long)SfrzEnum.SFRZ_WRZ.getCode().intValue())) continue;
                    QlrModel qlrModel = new QlrModel();
                    qlrModel.setQlrmc(gxYyQlr.getQlrmc());
                    qlrModelList.add(qlrModel);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.gxYySqxxHqRepository.deleteBySlbh(((GxYySqxx)sqxxList.get(0)).getSlbh());
                this.gxYySqxxHqRepository.saveBatch((List)list);
            }
            resultModel.setQlrList((List)qlrModelList);
        }
    }

    private Integer getSfrz(GxYyZdSqlx zdSqlx, GxYyQlr gxYyQlr) {
        Integer sfrz = SfrzEnum.SFRZ_WRZ.getCode();
        if (StringUtils.equals((CharSequence)QlrTypeEnum.QLRLX_QLR.getCode(), (CharSequence)gxYyQlr.getQlrlx())) {
            if (StringUtils.equals((CharSequence)zdSqlx.getQlrsfhq(), (CharSequence)Status2Enum.NO.getCode())) {
                sfrz = SfrzEnum.SFRZ_RZTG.getCode();
            }
        } else if (StringUtils.equals((CharSequence)QlrTypeEnum.QLRLX_YWR.getCode(), (CharSequence)gxYyQlr.getQlrlx())) {
            if (StringUtils.equals((CharSequence)zdSqlx.getYwrsfhq(), (CharSequence)Status2Enum.NO.getCode())) {
                sfrz = SfrzEnum.SFRZ_RZTG.getCode();
            }
        } else if (StringUtils.equals((CharSequence)QlrTypeEnum.QLRLX_JKR.getCode(), (CharSequence)gxYyQlr.getQlrlx())) {
            if (StringUtils.isBlank((CharSequence)zdSqlx.getJkrsfxyhq()) || StringUtils.equals((CharSequence)zdSqlx.getJkrsfxyhq(), (CharSequence)Status2Enum.NO.getCode())) {
                sfrz = SfrzEnum.SFRZ_RZTG.getCode();
            }
        } else {
            sfrz = SfrzEnum.SFRZ_RZTG.getCode();
        }
        if (StringUtils.equals((CharSequence)sfrz.toString(), (CharSequence)SfrzEnum.SFRZ_RZTG.getCode().toString())) {
            return sfrz;
        }
        if (StringUtils.equals((CharSequence)"0", (CharSequence)zdSqlx.getHqfs()) && StringUtils.equals((CharSequence)zdSqlx.getSfdy(), (CharSequence)StatusEnum.TRUE.getCode()) && StringUtils.equals((CharSequence)QlrTypeEnum.QLRLX_QLR.getCode(), (CharSequence)gxYyQlr.getQlrlx())) {
            sfrz = SfrzEnum.DRZ_GR.getCode();
        }
        return sfrz;
    }

    private String getSfqz(GxYyZdSqlx zdSqlx, GxYyQlr gxYyQlr) {
        String sfqz = SfqzEnum.SAQZ_NO.getCode();
        if (StringUtils.equals((CharSequence)QlrTypeEnum.QLRLX_QLR.getCode(), (CharSequence)gxYyQlr.getQlrlx())) {
            if (StringUtils.equals((CharSequence)zdSqlx.getQlrsfxyyq(), (CharSequence)StatusEnum.FALSE.getCode())) {
                sfqz = SfqzEnum.SAQZ_SUCCESS.getCode();
            }
        } else if (StringUtils.equals((CharSequence)QlrTypeEnum.QLRLX_YWR.getCode(), (CharSequence)gxYyQlr.getQlrlx())) {
            if (StringUtils.equals((CharSequence)zdSqlx.getYwrsfxyyq(), (CharSequence)StatusEnum.FALSE.getCode())) {
                sfqz = SfqzEnum.SAQZ_SUCCESS.getCode();
            }
        } else {
            sfqz = SfqzEnum.SAQZ_SUCCESS.getCode();
        }
        if (Status2Enum.NO.getCode().equals(gxYyQlr.getSfyq()) || StringUtils.isBlank((CharSequence)gxYyQlr.getSfyq())) {
            sfqz = SfqzEnum.SAQZ_SUCCESS.getCode();
        }
        return sfqz;
    }
}

