/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event.commit;

import cn.gtmap.hlw.core.domain.sqxx.SqxxCommitEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.commit.SqxxCommitParamsModel;
import cn.gtmap.hlw.core.domain.sqxx.model.commit.SqxxCommitResultModel;
import cn.gtmap.hlw.core.enums.dict.GyfsEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.enums.qlr.QlrTypeEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxHqRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdSqlxRepository;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SqxxCommitBeforeCheckQlrGyfsEvent
implements SqxxCommitEventService {
    private static final Logger log = LoggerFactory.getLogger(SqxxCommitBeforeCheckQlrGyfsEvent.class);
    @Autowired
    GxYySqxxHqRepository gxYySqxxHqRepository;
    @Autowired
    GxYySqxxRepository gxYySqxxRepository;
    @Autowired
    GxYyQlrRepository gxYyQlrRepository;
    @Autowired
    GxYyZdSqlxRepository gxYyZdSqlxRepository;

    public void doWork(SqxxCommitParamsModel paramsModel, SqxxCommitResultModel resultModel) {
        List sqxxList = paramsModel.getGxYySqxxList();
        if (CollectionUtils.isNotEmpty((Collection)sqxxList)) {
            for (GxYySqxx sqxx : sqxxList) {
                List qlrList = this.gxYyQlrRepository.selectQlrBySqid(sqxx.getSqid());
                if (!CollectionUtils.isNotEmpty((Collection)qlrList)) continue;
                List qlrDdsyGxYyQlrList = qlrList.stream().filter(qlr -> QlrTypeEnum.QLRLX_QLR.getCode().equals(qlr.getQlrlx()) && GyfsEnum.DDSY.getCode().equals(qlr.getGyfs())).collect(Collectors.toList());
                List qlrGtgyGxYyQlrList = qlrList.stream().filter(qlr -> QlrTypeEnum.QLRLX_QLR.getCode().equals(qlr.getQlrlx()) && !GyfsEnum.DDSY.getCode().equals(qlr.getGyfs())).collect(Collectors.toList());
                List ywrDdsyGxYyQlrList = qlrList.stream().filter(qlr -> QlrTypeEnum.QLRLX_YWR.getCode().equals(qlr.getQlrlx()) && GyfsEnum.DDSY.getCode().equals(qlr.getGyfs())).collect(Collectors.toList());
                List ywrGtgyGxYyQlrList = qlrList.stream().filter(qlr -> QlrTypeEnum.QLRLX_YWR.getCode().equals(qlr.getQlrlx()) && !GyfsEnum.DDSY.getCode().equals(qlr.getGyfs())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(qlrDdsyGxYyQlrList) && qlrDdsyGxYyQlrList.size() > 1) {
                    throw new BizException(ErrorEnum.CHECK_FAIL.getCode(), "\u6743\u5229\u4eba\u6570\u91cf\u5927\u4e8e1\uff0c\u5171\u6709\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u5355\u72ec\u6240\u6709\uff01");
                }
                if (CollectionUtils.isNotEmpty(qlrGtgyGxYyQlrList) && qlrGtgyGxYyQlrList.size() == 1) {
                    throw new BizException(ErrorEnum.CHECK_FAIL.getCode(), "\u6743\u5229\u4eba\u6570\u91cf\u7b49\u4e8e1\uff0c\u5171\u6709\u65b9\u5f0f\u4e0d\u662f\u5355\u72ec\u6240\u6709\uff01");
                }
                if (CollectionUtils.isNotEmpty(ywrDdsyGxYyQlrList) && ywrDdsyGxYyQlrList.size() > 1) {
                    throw new BizException(ErrorEnum.CHECK_FAIL.getCode(), "\u4e49\u52a1\u4eba\u6570\u91cf\u5927\u4e8e1\uff0c\u5171\u6709\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u5355\u72ec\u6240\u6709\uff01");
                }
                if (!CollectionUtils.isNotEmpty(ywrGtgyGxYyQlrList) || ywrGtgyGxYyQlrList.size() != 1) continue;
                throw new BizException(ErrorEnum.CHECK_FAIL.getCode(), "\u4e49\u52a1\u4eba\u6570\u91cf\u7b49\u4e8e1\uff0c\u5171\u6709\u65b9\u5f0f\u4e0d\u662f\u5355\u72ec\u6240\u6709\uff01");
            }
        }
    }
}

