/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event;

import cn.gtmap.hlw.core.domain.sqxx.UpdateSlztEventService;
import cn.gtmap.hlw.core.dto.sqxx.push.UpdateSlztDjParamsDTO;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYyProcessLysjRel;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYyProcessLysjRelRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpdateSlztDomainService {
    private static final Logger log = LoggerFactory.getLogger(UpdateSlztDomainService.class);
    @Resource
    private GxYySqxxRepository gxYySqxxRepository;
    @Resource
    private GxYyProcessLysjRelRepository lysjRelRepository;
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, UpdateSlztEventService> eventServiceMap;

    public void event(UpdateSlztDjParamsDTO paramsDTO) {
        LysjModel lysjList;
        GxYyProcessLysjRel gxYyProcessLysjRel;
        if (StringUtils.isBlank((CharSequence)paramsDTO.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        GxYySqxx gxYySqxx = this.gxYySqxxRepository.getSqxxOneBySlbh(paramsDTO.getSlbh());
        if (gxYySqxx == null) {
            gxYySqxx = this.gxYySqxxRepository.getSqxxOneByYwxtSlbh(paramsDTO.getSlbh());
            if (gxYySqxx != null) {
                paramsDTO.setDjslbh(paramsDTO.getSlbh());
                paramsDTO.setSlbh(gxYySqxx.getSlbh());
            } else {
                log.error("\u672a\u67e5\u8be2\u5230\u8be5\u7533\u8bf7\u4fe1\u606f");
                return;
            }
        }
        if ((gxYyProcessLysjRel = this.lysjRelRepository.getByLysjdmAndSqlx(paramsDTO.getLysjdm(), gxYySqxx.getSqlx())) != null) {
            paramsDTO.setProcessId(gxYyProcessLysjRel.getProcessId());
        }
        if ((lysjList = this.lysjRepository.queryLysjAndLydz(paramsDTO.getLysjdm(), paramsDTO.getProcessId())) == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), paramsDTO.getLysjdm() + ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            UpdateSlztEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsDTO);
        }
    }
}

