/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event;

import cn.gtmap.hlw.core.domain.sqxx.UpdateByApiEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.update.UpdateByApiParamsModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpdateByApiDomainService {
    private static final Logger log = LoggerFactory.getLogger(UpdateByApiDomainService.class);
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private GxYySqxxRepository sqxxRepository;
    @Resource
    private Map<String, UpdateByApiEventService> eventServiceMap;

    public void event(UpdateByApiParamsModel paramsModel) {
        List sqxxList = this.sqxxRepository.list(paramsModel.getSlbh());
        if (CollectionUtils.isEmpty((Collection)sqxxList)) {
            throw new BizException(ApplyCodeEnum.APPLY_SQXX_NULL.getCode(), ApplyCodeEnum.APPLY_SQXX_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getAnid());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        try {
            for (GxYyLydz lydz : lysjList.getLydzList()) {
                UpdateByApiEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                eventService.doWork(paramsModel);
            }
        }
        catch (BizException e) {
            throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
    }
}

