/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event;

import cn.gtmap.hlw.core.domain.sqxx.SqxxXzxxValidateEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.xzxx.SqxxXzxxEventParamsModel;
import cn.gtmap.hlw.core.domain.sqxx.model.xzxx.SqxxXzxxEventResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SqxxXzxxCheckDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, SqxxXzxxValidateEventService> eventServiceMap;

    public List<SqxxXzxxEventResultModel> event(SqxxXzxxEventParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), paramsModel.getLysjdm() + ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        ArrayList resultModel = Lists.newArrayList();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            SqxxXzxxValidateEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            paramsModel.setLydzms(lydz.getLydzms());
            eventService.doWork(paramsModel, (List)resultModel);
        }
        return resultModel;
    }
}

