/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event;

import cn.gtmap.hlw.core.domain.sqxx.SqxxSaveEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.SqxxSaveModel;
import cn.gtmap.hlw.core.domain.sqxx.model.commit.SqxxCommitResultModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.gtmap.hlw.core.util.thread.ThreadPoolMdcExecutor;
import cn.gtmap.hlw.domain.login.enums.LoginStatusEnum;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class SqxxSaveOrUpdateDomainService {
    private static final Logger log = LoggerFactory.getLogger(SqxxSaveOrUpdateDomainService.class);
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    RedisRepository redisRepository;
    @Autowired
    private Map<String, SqxxSaveEventService> eventServiceMap;

    public SqxxCommitResultModel event(List<SqxxSaveModel> sqxxModelList) {
        final LysjModel lysjList = this.lysjRepository.queryLysjAndLydz("lysjdm.sqxx.saveOrUpdate", sqxxModelList.get(0).getProcessId(), sqxxModelList.get(0).getAnid());
        if (CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getCode(), LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getMsg());
        }
        if (CollectionUtils.isNotEmpty(sqxxModelList)) {
            for (SqxxSaveModel sqxxSaveModel : sqxxModelList) {
                GxYySqxx sqxx = sqxxSaveModel.getSqxx();
                if (null == sqxx) {
                    throw new BizException((IError)ErrorEnum.DATA_INIT_FAIL);
                }
                if (StringUtils.isBlank((CharSequence)sqxx.getSqid())) {
                    sqxx.setSqid(StringUtil.hex32());
                }
                if (StringUtils.isBlank((CharSequence)sqxx.getSlbh())) {
                    sqxx.setSlbh(sqxxSaveModel.getSlbh());
                }
                if (!StringUtils.isBlank((CharSequence)sqxx.getQydm())) continue;
                sqxx.setQydm(StringUtil.toString((Object)this.redisRepository.get("register.dwdm")));
            }
        }
        if (CollectionUtils.isNotEmpty(sqxxModelList)) {
            List list = CollUtil.split(sqxxModelList, (int)100);
            for (List sqxxSaveModels : list) {
                ThreadPoolTaskExecutor executor = ThreadPoolMdcExecutor.taskExecutor();
                final CountDownLatch latch = new CountDownLatch(sqxxSaveModels.size());
                for (final SqxxSaveModel sqxxSaveModel : sqxxSaveModels) {
                    Callable call = new Callable(){

                        public Object call() {
                            try {
                                for (GxYyLydz lydz : lysjList.getLydzList()) {
                                    ((SqxxSaveEventService)SqxxSaveOrUpdateDomainService.this.eventServiceMap.get(lydz.getLydzsxl())).doWork(sqxxSaveModel);
                                }
                            }
                            catch (Exception e) {
                                log.error("SqxxSaveOrUpdateDomainService", (Throwable)e);
                                log.error("lydz.getLydzsxl():", (Object)JSONObject.toJSONString((Object)lysjList.getLydzList()));
                                log.error("latch.getCount():", (Object)latch.getCount());
                                if (e.getCause() instanceof BizException) {
                                    throw (BizException)e.getCause();
                                }
                                throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), e.getMessage());
                            }
                            finally {
                                latch.countDown();
                            }
                            return null;
                        }
                    };
                    try {
                        Future future = executor.submit(call);
                        future.get();
                    }
                    catch (ExecutionException e) {
                        log.error("SqxxSaveOrUpdateDomainService", (Throwable)e);
                        if (e.getCause() instanceof BizException) {
                            throw (BizException)e.getCause();
                        }
                        throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), e.getMessage());
                    }
                    catch (InterruptedException e) {
                        log.error("SqxxSaveOrUpdateDomainService", (Throwable)e);
                        throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), e.getMessage());
                    }
                }
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    log.error("SqxxSaveOrUpdateDomainService", (Throwable)e);
                }
                executor.shutdown();
            }
        }
        return null;
    }
}

