/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event;

import cn.gtmap.hlw.core.domain.sqxx.SqxxDeleteEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.SqxxDeleteModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.login.enums.LoginStatusEnum;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SqxxDeleteDomainService {
    private static final Logger log = LoggerFactory.getLogger(SqxxDeleteDomainService.class);
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, SqxxDeleteEventService> eventServiceMap;

    public void event(SqxxDeleteModel sqxxDeleteModel) {
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(sqxxDeleteModel.getLysjdm(), sqxxDeleteModel.getProcessId());
        if (CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getCode(), LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getMsg());
        }
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            SqxxDeleteEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(sqxxDeleteModel);
        }
    }
}

